import { AttendanceConfig } from '../models/attendanceconfig.js';

export const getAttendanceConfig = async (req, res) => {
    try {
        const config = await AttendanceConfig.getConfig();
        
        res.json({
            code: 200,
            status: true,
            message: "Attendance configuration retrieved successfully",
            response: config
        });
    } catch (error) {
        console.error('Get attendance config error:', error);
        res.json({
            code: 500,
            status: false,
            message: 'Failed to retrieve attendance configuration'
        });
    }
};

export const updateAttendanceConfig = async (req, res) => {
    try {
        await AttendanceConfig.updateConfig(req.body);
        const config = await AttendanceConfig.getConfig();
        
        res.json({
            code: 200,
            status: true,
            message: "Attendance configuration updated successfully",
            response: config
        });
    } catch (error) {
        console.error('Update attendance config error:', error);
        res.json({
            code: 500,
            status: false,
            message: 'Failed to update attendance configuration'
        });
    }
};