import { AttendanceResetModel } from '../models/attendancereset.model.js';

export const attendanceReset = async (req, res) => {
    let response = {};
    try {
        const userId = req.user.id;
        const date = new Date().toISOString().slice(0, 10);
        const task = await AttendanceResetModel.resetPunchout(userId, date);
        if (task) {
            return res.status(200).json({
                code: 200,
                status: true,
                message: 'Attendance punchout reset successfully',
                response: task
            });
        } else {
            return res.status(200).json({
                code: 204,
                status: false,
                message: 'No attendance Info not found',
                response: {}
            });
        }
    } catch (e) {
        return res.status(200).json({
            code: 500,
            status: false,
            message: 'Attendance reset -' + e.message,
            response
        });
    }
}; 