import { db } from "../utils/database.js";
import { findAttendanceRolewise } from "../models/attendancerolewisemodel.js";
import { AttendanceRolewiseModel } from '../models/attendancerolewisemodel.js';

export const getAttendanceRolewise = async (req, res) => {
    try {
        if (!req.user || !req.user.id) {
            return res.status(401).json({ status: 401, success: false, message: "Unauthorized: No user info" });
        }

        // Fetch user details from DB to get roles_id and branch_id
        let userRows = await db.query(
            "SELECT id, roles_id, branch_id FROM users WHERE id = ?",
            [Number(req.user.id)]
        );
        const user = userRows[0];
        if (!user) {
            return res.status(404).json({ status: 404, success: false, message: "User not found" });
        }
        if (!user.roles_id) {
            return res.status(400).json({ status: 400, success: false, message: "User has no roles_id" });
        }

        const { start_date, end_date } = req.query;

        // Get user's role and scope
        let scopeRows = await db.query(
            "SELECT scope FROM roles WHERE id = ?",
            [user.roles_id]
        );
        const scope = scopeRows[0]?.scope || '';

        const attendance = await findAttendanceRolewise({
            scope,
            userId: user.id,
            branchId: user.branch_id,
            startDate: start_date,
            endDate: end_date
        });

        return res.status(200).json({
            status: 200,
            success: true,
            message: "Attendance list fetched successfully",
            data: attendance || []
        });
    } catch (error) {
        console.error("Controller error:", error);
        return res.status(500).json({
            status: 500,
            success: false,
            message: "Error fetching attendance",
            error: error.message
        });
    }
};

export const datatableattendance = async (req, res) => {
    try {
        const {
            start = 1,
            length = 10,
            order_by = 'start_date',
            order_dir = 'DESC',
            search = '',
            start_date,
            end_date
        } = req.query;

        const page = parseInt(start);
        const limit = parseInt(length);
        const sortBy = order_by;
        const sortOrder = order_dir;

        const { attendance, total, present, absent } = await AttendanceRolewiseModel.datatableList({ page, limit, sortBy, sortOrder, search, startDate: start_date, endDate: end_date });
        const totalPages = Math.ceil(total / limit);
        const paginationMeta = {
            total,
            page,
            limit,
            present,
            absent,
            totalPages
        };
        return res.status(200).json({
            status: 200,
            success: true,
            message: 'Attendance list fetched successfully',
            data: attendance,
            total,
            pagination: paginationMeta
        });
    } catch (error) {
        return res.status(500).json({
            status: 500,
            success: false,
            message: 'Error fetching datatable attendance',
            error: error.message
        });
    }
};