import jwt from 'jsonwebtoken';
import { User } from '../models/user.js';
import { Applog } from '../models/applogs.js';
import { hashPassword } from '../utils/hash.js';
import { LoginLogs } from '../models/loginlogs.js';
import fetch from 'node-fetch';

async function getLocationFromIP(ip) {
    try {
        const response = await fetch(`http://ip-api.com/json/${ip}`);
        const data = await response.json();
        if (data.status === 'success') {
            return `${data.city || ''}, ${data.regionName || ''}, ${data.country || ''}`.replace(/^, |, ,/g, '').trim();
        }
        return null;
    } catch (e) {
        return null;
    }
}

export const login = async (req, res) => {
    try {
        console.log('Login attempt:', { mobile: req.body.mobile });
        const { mobile, password, mac_address } = req.body;
        
        
        // Find user by mobile
        const user = await User.findByMobile(mobile);
        console.log('User found:', user ? 'Yes' : 'No');
        if (!user) {
            return res.status(401).json({
                status: 401,
                message: 'Invalid mobile number or password'
            });
        }
        let ip = req.headers['x-forwarded-for'] || req.socket.remoteAddress;
        if (ip && ip.includes(',')) {
          ip = ip.split(',')[0].trim();
        }
        if (ip && ip.includes('::ffff:')) {
          ip = ip.split('::ffff:')[1];
        }
        let loginIp = ip;
        if (loginIp === '::1' || loginIp === '127.0.0.1') {
            // Optionally, you can set this to your public IP for local testing
             loginIp = '171.79.59.209';
        }
        console.log('Login IP:', loginIp);
        // Check if login IP matches user's stored IP address
        /*if (user.ip_address && loginIp && user.ip_address !== loginIp) {
            return res.status(401).json({
                status: 401,
                message: 'Login not allowed from this IP address'
            });
        }*/
        // Verify password using hash
        const hashedPassword = hashPassword(password);
        console.log('Hashed password:', hashedPassword);
        
        console.log('Password comparison:', {
            providedHash: hashedPassword,
            storedHash: user.password,
            matches: hashedPassword === user.password
        });

        if (hashedPassword !== user.password) {
            return res.status(401).json({
                status: 401,
                message: 'Invalid mobile number or password'
            });
        }
        if (user.roles_id==3) {
            return res.status(401).json({
                status: 401,
                message: 'Invalid mobile number or password'
            });
        }

        // Get user branches
        const branches = await User.getUserBranches(user.id);
        
        // Generate JWT token
        const token = jwt.sign(
            { id: user.id },
            process.env.JWT_SECRET,
            { expiresIn: '24h' }
        );

        // Prepare response
        const userResponse = {
            status: 200,
            message: 'Login successfull',
            user: {
                token,
                id: user.id,
                username: user.name,
                email: user.email,
                mobile: user.mobile,
                role: user.roles_id,
                role_name: user.role_name,
                is_admin: Boolean(user.is_admin),
                fcm_token: user.fcm_token,
                branches: branches
            }
        };
        
        
        // Insert login log
        try {
            const now = new Date();
            const location = loginIp ? await getLocationFromIP(loginIp) : null;
            await LoginLogs.insert({
                user_id: user.id,
                mac_address: mac_address || null,
                location: location,
                ip_address: loginIp,
                last_login: now,
                date: now,
                message: 'Login successful',
                status: 1
            });
        } catch (logErr) {
            console.error('Failed to insert login log:', logErr);
        }

        res.json(userResponse);
    } catch (error) {
        console.error('Login error:', error);
        res.status(500).json({
            status: 500,
            message: 'Internal server error'
        });
    }
};