import { Branch } from '../models/branch.js';

export const createBranch = async (req, res) => {
    try {
        const branchId = await Branch.create(req.body);
        const branch = await Branch.findById(branchId);
        
        res.status(201).json({
            status: 201,
            message: 'Branch created successfully',
            branch
        });
    } catch (error) {
        console.error('Create branch error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to create branch'
        });
    }
};

export const updateBranch = async (req, res) => {
    try {
        const { id } = req.params;
        await Branch.update(id, req.body);
        const branch = await Branch.findById(id);

        res.json({
            status: 200,
            message: 'Branch updated successfully',
            branch
        });
    } catch (error) {
        console.error('Update branch error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to update branch'
        });
    }
};

export const deleteBranch = async (req, res) => {
    try {
        const { id } = req.params;
        await Branch.softDelete(id);

        res.json({
            status: 200,
            message: 'Branch deleted successfully'
        });
    } catch (error) {
        console.error('Delete branch error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to delete branch'
        });
    }
};

export const listBranches = async (req, res) => {
    try {
        const branches = await Branch.list();
        
        res.json({
            status: 200,
            message: 'Branches retrieved successfully',
            branches
        });
    } catch (error) {
        console.error('List branches error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to retrieve branches'
        });
    }
};