import { db } from '../utils/database.js';

export const getUsersByBranches = async (req, res) => {
    try {
        const { branch } = req.body;
        if (!Array.isArray(branch) || branch.length === 0) {
            return res.status(400).json({
                status: 400,
                success: false,
                message: 'branch must be a non-empty array of branch IDs',
                data: []
            });
        }
        // Build placeholders for SQL IN clause
        const placeholders = branch.map(() => '?').join(',');
        const users = await db.query(
            `SELECT * FROM users WHERE branch_id IN (${placeholders})`,
            branch
        );
        return res.status(200).json({
            status: 200,
            success: true,
            message: 'Users fetched successfully',
            data: users
        });
    } catch (error) {
        return res.status(500).json({
            status: 500,
            success: false,
            message: 'Failed to fetch users',
            error: error.message
        });
    }
}; 