
import { User } from '../models/user.js';

export const changeDevice = async (req, res) => {
  try {
    const { mobile_no, deviceId, device_info } = req.body;
    if (!mobile_no) {
      return res.status(400).json({ code: 400, status: false, message: 'mobile_no is required', response: {} });
    }

    const result = await User.changeDeviceToken(mobile_no, deviceId, device_info);
    if (!result) {
      return res.status(400).json({ code: 400, status: false, message: 'Mobile number not valid', response: {} });
    }
    if (result === 'invalid_role') {
      return res.status(200).json({ code: 400, status: true, message: 'Role not valid', response: {} });
    }
    return res.status(200).json({
      code: 200,
      status: true,
      message: 'Your mobile has been successfully updated. Once the admin approves, you can log in or contact the admin',
      response: result
    });
  } catch (e) {
    return res.status(500).json({ code: 500, status: false, message: 'Login -' + e.message, response: {} });
  }
}; 