import { findAllCheckoutReports } from '../models/checkoutReport.js';
import { CheckoutReport } from '../models/checkoutReport.js';

export const getAllCheckoutReport = async (req, res) => {
  try {
    const { branch, userIds, startdate, enddate } = req.body;
    const result = await findAllCheckoutReports({ branch, userIds, startdate, enddate });
    return res.status(200).json({
      status: 200,
      success: true,
      message: 'Checkout reports fetched successfully',
      data: result
    });
  } catch (error) {
    console.error('Error in getAllCheckoutReport:', error);
    return res.status(500).json({
      status: 500,
      success: false,
      message: 'Error fetching checkout reports',
      error: error.message
    });
  }
};

export const datatableCheckoutReports = async (req, res) => {
    try {
        const {
            start = 1,
            length = 10,
            order_by = 'checkin_at',
            order_dir = 'DESC',
            search = '',
            userIds = [],
            branch = [],
            startdate,
            enddate
        } = req.body;

        // Parse arrays if sent as comma-separated strings
        const userIdsArr = typeof userIds === 'string' ? userIds.split(',').map(Number) : userIds;
        const branchArr = typeof branch === 'string' ? branch.split(',').map(Number) : branch;

        const page = parseInt(start);
        const limit = parseInt(length);
        const sortBy = order_by;
        const sortOrder = order_dir;

        const { data, total } = await CheckoutReport.datatableList({
            page, limit, sortBy, sortOrder, search,
            userIds: userIdsArr,
            branch: branchArr,
            startdate,
            enddate
        });
        const totalPages = Math.ceil(total / limit);
        const paginationMeta = {
            total,
            page,
            limit,
            totalPages
        };
        return res.status(200).json({
            status: 200,
            success: true,
            message: 'Checkout reports fetched successfully',
            data,
            total,
            pagination: paginationMeta
        });
    } catch (error) {
        return res.status(500).json({
            status: 500,
            success: false,
            message: 'Error fetching datatable checkout reports',
            error: error.message
        });
    }
}; 