import { Task } from '../models/task.js';

export const claimUpdate = async (req, res) => {
    try {
        const { claim, status, remarks } = req.body;
        const approvedBy = req.user?.id ?? null; // Use null if undefined

        if (!claim || !status || approvedBy === null) {
            return res.status(400).json({
                code: 400,
                status: false,
                message: 'claim, status, and approvedBy (auth user) are required.',
                response: {}
            });
        }

        await Task.claimUpdate({
            claimIds: claim,
            status,
            remarks,
            approvedBy
        });

        return res.status(200).json({
            code: 200,
            status: true,
            message: 'Selected claims have been updated.',
            response: {}
        });
    } catch (err) {
        return res.status(500).json({
            code: 500,
            status: false,
            message: err.message,
            response: {}
        });
    }
};