import { findAllClaimReports } from '../models/claimReport.js';
import { ClaimReport } from '../models/claimReport.js';

export const getAllClaimReport = async (req, res) => {
  try {
    const { branch, userIds, startdate, enddate } = req.body;
    const result = await findAllClaimReports({ branch, userIds, startdate, enddate });
    return res.status(200).json({
      status: 200,
      success: true,
      message: 'Claim reports fetched successfully',
      data: result
    });
  } catch (error) {
    console.error('Error in getAllClaimReport:', error);
    return res.status(500).json({
      status: 500,
      success: false,
      message: 'Error fetching claim reports',
      error: error.message
    });
  }
};

export const datatableClaimReports = async (req, res) => {
    try {
        const {
            start = 1,
            length = 10,
            order_by = 'checkin_at',
            order_dir = 'DESC',
            search = '',
            userIds = [],
            branch = [],
            startdate,
            enddate
        } = req.body;

        // Parse arrays if sent as comma-separated strings
        const userIdsArr = typeof userIds === 'string' ? userIds.split(',').map(Number) : userIds;
        const branchArr = typeof branch === 'string' ? branch.split(',').map(Number) : branch;

        const page = parseInt(start);
        const limit = parseInt(length);
        const sortBy = order_by;
        const sortOrder = order_dir;

        const { reports, total } = await ClaimReport.datatableList({
            page, limit, sortBy, sortOrder, search,
            userIds: userIdsArr,
            branch: branchArr,
            startdate,
            enddate
        });
        const totalPages = Math.ceil(total / limit);
        const paginationMeta = {
            total,
            page,
            limit,
            totalPages
        };
        return res.status(200).json({
            status: 200,
            success: true,
            message: 'Claim reports fetched successfully',
            data: reports,
            total,
            pagination: paginationMeta
        });
    } catch (error) {
        return res.status(500).json({
            status: 500,
            success: false,
            message: 'Error fetching datatable claim reports',
            error: error.message
        });
    }
}; 