import { ConveyanceConfig } from '../models/conveyanceconfig.js';

export const listConfig = async (req, res) => {
    try {
        const configs = await ConveyanceConfig.list();
        
        res.json({
            code: 200,
            status: true,
            message: "Conveyance configurations retrieved successfully",
            response: configs
        });
    } catch (error) {
        console.error('List conveyance config error:', error);
        res.json({
            code: 500,
            status: false,
            message: 'Failed to retrieve conveyance configurations'
        });
    }
};

export const updateConfig = async (req, res) => {
    try {
        const { id } = req.params;
        await ConveyanceConfig.update(id, req.body);
        const config = await ConveyanceConfig.findById(id);
        
        if (!config) {
            return res.json({
                code: 404,
                status: false,
                message: 'Conveyance configuration not found'
            });
        }

        res.json({
            code: 200,
            status: true,
            message: "Conveyance configuration updated successfully",
            response: config
        });
    } catch (error) {
        console.error('Update conveyance config error:', error);
        res.json({
            code: 500,
            status: false,
            message: 'Failed to update conveyance configuration'
        });
    }
};