import { db } from "../utils/database.js";
import { findConveyanceRolewise } from "../models/conveyancerolewisemodel.js";
import { ConveyanceRolewiseModel } from '../models/conveyancerolewisemodel.js';

export const getConveyanceRolewise = async (req, res) => {
    try {
        if (!req.user || !req.user.id) {
            return res.status(401).json({ status: 401, success: false, message: "Unauthorized: No user info" });
        }

        // Fetch user details from DB to get roles_id and branch_id
        let userRows = await db.query(
            "SELECT id, roles_id, branch_id FROM users WHERE id = ?",
            [Number(req.user.id)]
        );
        const user = userRows[0];
        if (!user) {
            return res.status(404).json({ status: 404, success: false, message: "User not found" });
        }
        if (!user.roles_id) {
            return res.status(400).json({ status: 400, success: false, message: "User has no roles_id" });
        }

        const { start_date, end_date } = req.query;

        // Get user's role and scope
        let scopeRows = await db.query(
            "SELECT scope FROM roles WHERE id = ?",
            [user.roles_id]
        );
        const scope = scopeRows[0]?.scope || '';

        const conveyance = await findConveyanceRolewise({
            scope,
            userId: user.id,
            branchId: user.branch_id,
            startDate: start_date,
            endDate: end_date
        });

        return res.status(200).json({
            status: 200,
            success: true,
            message: "Conveyance list fetched successfully",
            data: conveyance || []
        });
    } catch (error) {
        console.error("Controller error:", error);
        return res.status(500).json({
            status: 500,
            success: false,
            message: "Error fetching conveyance",
            error: error.message
        });
    }
};

/*export const datatableconveyance = async (req, res) => {
    try {
        const {
            start = 1,
            length = 10,
            order_by = 'name',
            order_dir = 'ASC',
            search = ''
        } = req.query;

        const page = parseInt(start);
        const limit = parseInt(length);
        const sortBy = order_by;
        const sortOrder = order_dir;

        const { conveyance, total } = await ConveyanceRolewiseModel.datatableList({ page, limit, sortBy, sortOrder, search });
        const totalPages = Math.ceil(total / limit);
        const paginationMeta = {
            total,
            page,
            limit,
            totalPages
        };
        return res.status(200).json({
            status: 200,
            success: true,
            message: 'Conveyance list fetched successfully',
            data: conveyance,
            total,
            pagination: paginationMeta
        });
    } catch (error) {
        return res.status(500).json({
            status: 500,
            success: false,
            message: 'Error fetching datatable conveyance',
            error: error.message
        });
    }
};*/
export const datatableconveyance = async (req, res) => {
    try {
        if (!req.user || !req.user.id) {
            return res.status(401).json({
                status: 401,
                success: false,
                message: "Unauthorized: No user info"
            });
        }

        const userId = Number(req.user.id);

        // Fetch user details
        const userRows = await db.query(
            "SELECT id, roles_id, branch_id FROM users WHERE id = ?",
            [userId]
        );
        const user = userRows[0];
        if (!user) {
            return res.status(404).json({
                status: 404,
                success: false,
                message: "User not found"
            });
        }
        if (!user.roles_id) {
            return res.status(400).json({
                status: 400,
                success: false,
                message: "User has no roles_id"
            });
        }

        // Get scope from role
        const scopeRows = await db.query(
            "SELECT scope FROM roles WHERE id = ?",
            [user.roles_id]
        );
        const scope = scopeRows[0]?.scope || '';

        // Extract query params
        const {
            start = 1,
            length = 10,
            order_by = 'name',
            order_dir = 'ASC',
            search = '',
            start_date,
            end_date
        } = req.query;

        const page = parseInt(start);
        const limit = parseInt(length);
        const sortBy = order_by;
        const sortOrder = order_dir;

        // Call model with full context
        const { conveyance, total } = await ConveyanceRolewiseModel.datatableList({
            page,
            limit,
            sortBy,
            sortOrder,
            search,
            startDate: start_date,
            endDate: end_date,
            scope,
            userId: user.id,
            branchId: user.branch_id
        });

        const totalPages = Math.ceil(total / limit);
        const paginationMeta = {
            total,
            page,
            limit,
            totalPages
        };

        return res.status(200).json({
            status: 200,
            success: true,
            message: 'Conveyance list fetched successfully',
            data: conveyance,
            total,
            pagination: paginationMeta
        });
    } catch (error) {
        console.error("Controller error:", error);
        return res.status(500).json({
            status: 500,
            success: false,
            message: 'Error fetching datatable conveyance',
            error: error.message
        });
    }
};