import { 
    getCustomerById, 
    getContactsByCustomer, 
    getProjectsByCustomer, 
    getTasksByCustomer, 
    getFilesByCustomer 
} from '../models/customer.model.js';

export const getCustomerDetailsPage = async (req, res) => {
    const customerId = req.params.id;
    try {
        const customer = await getCustomerById(customerId);
        const contacts = await getContactsByCustomer(customerId);
        const projects = await getProjectsByCustomer(customerId);
        const tasks = await getTasksByCustomer(customerId);
        const files = await getFilesByCustomer(customerId);

        res.json({
            status: true,
            message: "Customer details fetched successfully",
            data: {
                customer,
                contacts,
                projects,
                tasks,
                files
            }
        });
    } catch (error) {
        res.status(500).json({
            status: false,
            message: "Error fetching customer details",
            error: error.message
        });
    }
};
