import { db } from '../utils/database.js';
import { TaskSubcategory } from '../models/tasksubcategory.js';

export const getDashboardDetails = async (req, res) => {
    const { fromDate, toDate } = req.query;

    try {
        // Attendance present and absent count
        let attendance = await db.query(
            `SELECT 
                SUM(CASE WHEN status != 'Open' THEN 1 ELSE 0 END) AS present_count,
                SUM(CASE WHEN status = 'Open' THEN 1 ELSE 0 END) AS absent_count
             FROM tasks
             WHERE tasktype_id='1' and start_date BETWEEN ? AND ?`,
            [fromDate, toDate]
        );

        // Get all subcategories
        const subcategories = await TaskSubcategory.list();
        // For each subcategory, count tasks in the date range
        const taskCounts = [];
        for (const subcat of subcategories) {
            const [countResult] = await db.query(
                `SELECT COUNT(*) AS task_count FROM tasks WHERE tasksubcategory_id = ? AND start_date BETWEEN ? AND ?`,
                [subcat.id, fromDate, toDate]
            );
            taskCounts.push({
                tasksubcategory_id: subcat.id,
                subcategory: subcat.subcategory,
                task_count: countResult.task_count
            });
        }

        // Active users' current location
        let userLocations = await db.query(
            `SELECT id, name, current_latitude, current_longitude
             FROM users
             WHERE active = '1' AND current_latitude != ''`
        );

        res.status(200).json({
            status: 200,
            success: true,
            message: "Dashboard details fetched successfully",
            data: {
                attendance: attendance[0],
                taskCounts,
                userLocations
            }
        });
    } catch (error) {
        res.status(500).json({
            status: 500,
            success: false,
            message: "Failed to fetch dashboard details",
            error: error.message
        });
    }
};