import { User } from '../models/user.js';

export const approveDevice = async (req, res) => {
    try {
        const { user_id } = req.body;
        console.error('Device approval error:', user_id);
        if (!user_id) {
            return res.status(400).json({
                status: 400,
                message: 'User ID is required'
            });
        }

        await User.approveDevice(user_id);
        
        res.status(200).json({
            status: 200,
            message: 'Device approved successfully'
        });
    } catch (error) {
        console.error('Device approval error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to approve device: ' + error.message
        });
    }
};