import { Task } from '../models/task.js';
import { validationResult } from 'express-validator';

export const financeClaimUpdate = async (req, res) => {
    const errors = validationResult(req);
    if (!errors.isEmpty()) {
        return res.status(400).json({
            code: 400,
            status: false,
            message: 'Validation failed',
            response: errors.array()
        });
    }

    try {
        const { claim, status, remarks } = req.body;
        const financeApprovedBy = req.user?.id ?? null;

        if (!claim || !status || financeApprovedBy === null) {
            return res.status(400).json({
                code: 400,
                status: false,
                message: 'claim, status, and financeApprovedBy (auth user) are required.',
                response: {}
            });
        }

        await Task.financeClaimUpdate({
            claimIds: claim,
            status,
            remarks,
            financeApprovedBy
        });

        return res.status(200).json({
            code: 200,
            status: true,
            message: 'Selected claims have been finance approved.',
            response: {}
        });
    } catch (err) {
        return res.status(500).json({
            code: 500,
            status: false,
            message: err.message,
            response: {}
        });
    }
};