import { FirebaseInbox } from '../models/firebaseinbox.js';

export const createNotification = async (req, res) => {
    try {
        const id = await FirebaseInbox.create(req.body);
        res.status(201).json({
            code: 201,
            status: true,
            message: 'Notification created',
            notification_id: id
        });
    } catch (error) {
        res.status(500).json({ code: 500, status: false, message: error.message });
    }
};

export const listNotifications = async (req, res) => {
    try {
        const user_id = req.user?.id ?? null;
        const notifications = await FirebaseInbox.list(user_id);
        res.status(200).json({
            code: 200,
            status: true,
            notifications
        });
    } catch (error) {
        res.status(500).json({ code: 500, status: false, message: error.message });
    }
};

export const updateNotification = async (req, res) => {
    try {
        const { id } = req.params;
        const { read_status } = req.body;
        await FirebaseInbox.update(id, read_status);
        res.status(200).json({
            code: 200,
            status: true,
            message: 'Notification updated'
        });
    } catch (error) {
        res.status(500).json({ code: 500, status: false, message: error.message });
    }
};