import { db } from '../utils/database.js';
import axios from 'axios';

export const forceCheckout = async (req, res) => {
    try {
        const date = new Date().toISOString().split('T')[0];
        
        // Get all active users except admin
        const users = await db.query(`
            SELECT u.*, b.branch_lat, b.branch_long, b.location as branch_location, r.default_transport
            FROM users u
            LEFT JOIN branches b ON u.branch_id = b.id
            LEFT JOIN roles r ON u.roles_id = r.id
            WHERE u.active = 1 AND u.roles_id != 1
        `);

        const [attendanceConfig] = await db.query('SELECT * FROM attendanceconfigs LIMIT 1');
        const [claimConfig] = await db.query('SELECT * FROM claimconfigs LIMIT 1');
        
        for (const user of users) {
            // Get attendance task in progress
            console.log(date);
            const [attendance] = await db.query(`
                SELECT * FROM tasks 
                WHERE tasktype_id = 1 AND user_id = ? AND start_date = ? AND status = 'Inprogress'
            `, [user.id, date]);

            if (attendance) {

            console.log(attendance.id);
                await db.query(`
                    UPDATE tasks 
                    SET checkout_at = NOW(), \`force\` = 1, status = 'Closed'
                    WHERE id = ?
                `, [attendance.id]);
            }
console.log(">>>>>");
            // Get other tasks in progress
            const [task] = await db.query(`
                SELECT * FROM tasks 
                WHERE tasktype_id != 1 AND user_id = ? AND start_date = ? AND status = 'Inprogress'
            `, [user.id, date]);

            if (task) {

console.log(">>>>>get task");
                await db.query(`
                    UPDATE tasks 
                    SET checkout_lat = softcheckout_lat, checkout_long = softcheckout_long,
                        checkout_location = soft_location, checkout_at = soft_datetime, \`force\` = 1
                    WHERE id = ?
                `, [task.id]);

                if (attendance) {
                    await db.query(`
                        UPDATE tasks 
                        SET checkout_lat = ?, checkout_long = ?, checkout_location = ?
                        WHERE id = ?
                    `, [user.branch_lat, user.branch_long, user.branch_location, attendance.id]);
                }
            } else {
                // Get soft checkout task
                const [softTask] = await db.query(`
                    SELECT * FROM tasks 
                    WHERE tasktype_id != 1 AND user_id = ? AND start_date = ? AND soft_checkout = 1
                    ORDER BY soft_datetime DESC LIMIT 1
                `, [user.id, date]);

                if (softTask && attendance) {
                    await db.query(`
                        UPDATE tasks 
                        SET checkout_at = FROM_UNIXTIME(?), checkout_lat = ?, checkout_long = ?, checkout_location = ?
                        WHERE id = ?
                    `, [softTask.soft_datetime, user.branch_lat, user.branch_long, user.branch_location, attendance.id]);
                }
            }

            // Calculate distance and conveyance
            const [lastTask] = await db.query(`
                SELECT * FROM tasks 
                WHERE user_id = ? AND DATE(checkin_at) = ? AND checkin_lat != '' AND checkin_long != ''
                ORDER BY checkin_at DESC LIMIT 1
            `, [user.id, date]);

            if (lastTask && attendance) {
                let origin = `${lastTask.checkin_lat},${lastTask.checkin_long}`;
                
                // Check for company location
                if (claimConfig?.customerlocation === 1 && lastTask.company_id) {
                    const [company] = await db.query('SELECT * FROM companies WHERE id = ?', [lastTask.company_id]);
                    if (company) {
                        origin = `${company.company_lat},${company.company_long}`;
                    }
                }

                let destination;
                if (attendanceConfig?.allow_branchlast_site === '1') {
                    destination = `${user.branch_lat},${user.branch_long}`;
                } else {
                    destination = `${req.body.checkin_lat || user.branch_lat},${req.body.checkin_long || user.branch_long}`;
                }

                // Calculate distance using Google Maps API
                let distance = 0;
                try {
                    const response = await axios.get('https://maps.googleapis.com/maps/api/distancematrix/json', {
                        params: {
                            origins: origin,
                            destinations: destination,
                            mode: 'driving',
                            key: process.env.GOOGLE_API_KEY
                        }
                    });

                    if (response.data.status === 'OK') {
                        const distanceInMeters = response.data.rows[0].elements[0].distance.value;
                        distance = distanceInMeters / 1000;
                    }
                } catch (error) {
                    console.error('Distance calculation error:', error);
                }

                // Calculate shortest distance if home location approved
                if (attendance.tasktype_id === 1 && user.home_latitude && user.home_approval === 'Approved') {
                    try {
                        const homeResponse = await axios.get('https://maps.googleapis.com/maps/api/distancematrix/json', {
                            params: {
                                origins: `${user.home_latitude},${user.home_longitude}`,
                                destinations: `${lastTask.checkin_lat},${lastTask.checkin_long}`,
                                mode: 'driving',
                                key: process.env.GOOGLE_API_KEY
                            }
                        });

                        if (homeResponse.data.status === 'OK') {
                            const homeDistanceInMeters = homeResponse.data.rows[0].elements[0].distance.value;
                            const homeDistance = homeDistanceInMeters / 1000;
                            distance = Math.min(distance, homeDistance);
                        }
                    } catch (error) {
                        console.error('Home distance calculation error:', error);
                    }
                }

                // Get conveyance rate
                const [conveyanceConfig] = await db.query(`
                    SELECT * FROM conveyanceconfigs 
                    WHERE transport_mode = ? OR transport_mode IS NULL
                    ORDER BY transport_mode DESC LIMIT 1
                `, [user.default_transport || 'Bike']);

                const amount = distance * (conveyanceConfig?.conveyance_charge || 0);

                await db.query(`
                    UPDATE tasks 
                    SET distance_travelled = ?, transport_mode = ?, claim_amount = ?, claim_status = 'Pending'
                    WHERE id = ?
                `, [distance, user.default_transport || 'Bike', amount, attendance.id]);
            }
        }

        res.json({
            code: 200,
            status: true,
            message: 'Attendance force checkout successfully',
            response: {}
        });

    } catch (error) {
        console.error('Force checkout error:', error);
        res.status(500).json({
            code: 500,
            status: false,
            message: 'Attendance force checkout failed - ' + error.message,
            response: {}
        });
    }
};