import { User } from '../models/user.js';

export const approveHomeLocation = async (req, res) => {
    try {
        const { user_id, status } = req.body;
        const approvedBy = req.user.id;

        if (!user_id || !status) {
            return res.status(400).json({
                status: 400,
                message: 'User ID and status are required'
            });
        }

        await User.approveHomeLocation(user_id, status);
        
        res.status(200).json({
            status: 200,
            message: `Home location ${status} successfully`
        });
    } catch (error) {
        console.error('Home location approval error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to update home location approval status'
        });
    }
};
