import { Manager } from '../models/manager.js';

export const listManagers = async (req, res) => {
    try {
        const managers = await Manager.list();
        
        res.status(200).json({
            status: 200,
            message: 'Managers fetched successfully',
            data: managers
        });
    } catch (error) {
        console.error('List managers error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to fetch managers'
        });
    }
};

export const getManagerById = async (req, res) => {
    try {
        const { id } = req.params;
        const manager = await Manager.findById(id);
        
        if (!manager) {
            return res.status(404).json({
                status: 404,
                message: 'Manager not found'
            });
        }
        
        res.status(200).json({
            status: 200,
            message: 'Manager fetched successfully',
            data: manager
        });
    } catch (error) {
        console.error('Get manager error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to fetch manager'
        });
    }
};