import { Package } from '../models/package.js';

export const createPackage = async (req, res) => {
    try {
        const packageId = await Package.create(req.body, req.user.id);
        const package_ = await Package.findById(packageId);
        
        res.status(201).json({
            status: 201,
            message: 'Package created successfully',
            package: package_
        });
    } catch (error) {
        console.error('Create package error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to create package'
        });
    }
};

export const updatePackage = async (req, res) => {
    try {
        const { id } = req.params;
        await Package.update(id, req.body);
        const package_ = await Package.findById(id);

        res.json({
            status: 200,
            message: 'Package updated successfully',
            package: package_
        });
    } catch (error) {
        console.error('Update package error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to update package'
        });
    }
};

export const deletePackage = async (req, res) => {
    try {
        const { id } = req.params;
        await Package.softDelete(id);

        res.json({
            status: 200,
            message: 'Package deleted successfully'
        });
    } catch (error) {
        console.error('Delete package error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to delete package'
        });
    }
};

export const listPackages = async (req, res) => {
    try {
        const packages = await Package.list();
        
        res.json({
            status: 200,
            message: 'Packages retrieved successfully',
            packages
        });
    } catch (error) {
        console.error('List packages error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to retrieve packages'
        });
    }
};

export const getPackageDetails = async (req, res) => {
    try {
        const { id } = req.params;

        if (!id) {
            return res.json({
                code: 400,
                status: false,
                message: 'Package ID is required'
            });
        }

        const result = await Package.getPackageDetails(id);
        
        res.json({
            code: 200,
            status: true,
            message: 'Package details retrieved successfully',
            response: result
        });
    } catch (error) {
        console.error('Get package details error:', error);
        res.json({
            code: error.message === 'Package not found' ? 404 : 500,
            status: false,
            message: error.message || 'Failed to retrieve package details'
        });
    }
};