import { Product } from '../models/product.js';
import { db } from '../utils/database.js';
export const createProduct = async (req, res) => {
    try {
        const productId = await Product.create(req.body);
        const product = await Product.findById(productId);
        
        res.status(201).json({
            status: 201,
            message: 'Product created successfully',
            product
        });
    } catch (error) {
        console.error('Create product error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to create product'
        });
    }
};

export const updateProduct = async (req, res) => {
    try {
        const { id } = req.params;
        await Product.update(id, req.body);
        const product = await Product.findById(id);

        res.json({
            status: 200,
            message: 'Product updated successfully',
            product
        });
    } catch (error) {
        console.error('Update product error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to update product'
        });
    }
};

export const deleteProduct = async (req, res) => {
    try {
        const { id } = req.params;
        await Product.softDelete(id);

        res.json({
            status: 200,
            message: 'Product deleted successfully'
        });
    } catch (error) {
        console.error('Delete product error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to delete product'
        });
    }
};

export const listProducts = async (req, res) => {
    try {
        const products = await Product.list();
        
        res.json({
            status: 200,
            message: 'Products retrieved successfully',
            products
        });
    } catch (error) {
        console.error('List products error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to retrieve products'
        });
    }
};

export const getProductChecklists = async (req, res) => {
    try {
        const { product_id } = req.params;
        if (!product_id) {
            return res.status(400).json({
                code: 400,
                status: false,
                message: 'Product ID is required',
                response: []
            });
        }

        const [rows] = await db.query(
            `SELECT id, product_id, dropdown as checklist, status, created_at, updated_at
             FROM taskcategoryoptions
             WHERE product_id = ? AND status = 1
             ORDER BY created_at DESC`,
            [product_id]
        );

        return res.status(200).json({
            code: 200,
            status: true,
            message: 'Product checklists fetched successfully',
            response: rows || []
        });
    } catch (error) {
        console.error('Get product checklists error:', error);
        return res.status(500).json({
            code: 500,
            status: false,
            message: 'Failed to fetch product checklists',
            response: []
        });
    }
};