import { getUserProfile, updateUserProfile } from '../models/profile.model.js';

export const viewProfile = async (req, res) => {
    let response = {};
    try {
        const userId = req.user.id;
        const profileData = await getUserProfile(userId);

        if (!profileData.user) {
            return res.status(400).json({
                code: 400,
                status: false,
                message: 'User not valid',
                response: {}
            });
        }

        response = profileData;
        return res.status(200).json({
            code: 200,
            status: true,
            message: 'Profile Data',
            response
        });
    } catch (e) {
        return res.status(500).json({
            code: 500,
            status: false,
            message: 'Login - ' + e.message,
            response: {}
        });
    }
};

export const profileUpdate = async (req, res) => {
    try {
        const { id } = req.body;
        if (!id || !req.file) {
            return res.status(400).json({ code: 400, status: false, message: 'id and profile are required' });
        }

        const profile_pic = req.file.filename;
        const updateData = {
            id,
            profile_pic
        };

        const user = await updateUserProfile(updateData);

        if (user) {
            return res.status(200).json({ code: 200, status: true, message: 'Profile add success', response: user });
        } else {
            return res.status(400).json({ code: 400, status: false, message: 'Profile add failed' });
        }
    } catch (e) {
        return res.status(500).json({ code: 500, status: false, message: 'Profile update - ' + e.message });
    }
};