
import { findAllProjectReports, Project } from '../models/project.js';

export const getAllProjectReport = async (req, res) => {
  try {
    const { branch, userIds, startdate, enddate, draw } = req.body;

    const userId = req.user?.id || req.body.userId;
    const result = await findAllProjectReports({ branch, userIds, startdate, enddate });
    return res.status(200).json({
      status: 200,
      success: true,
      message: 'Project reports fetched successfully',
      data: result
    });
  } catch (error) {
    console.error('Error in getAllProjectReport:', error);
    return res.status(500).json({
      status: 500,
      success: false,
      message: 'Error fetching project reports',
      error: error.message
    });
  }
};

export const datatableProjectReports = async (req, res) => {
    try {
        const {
            start = 1,
            length = 10,
            order_by = 'created_at',
            order_dir = 'DESC',
            search = '',
            userIds = [],
            branch = [],
            startdate,
            enddate,
            status
        } = req.body;

        // Parse arrays if sent as comma-separated strings
        const userIdsArr = typeof userIds === 'string' ? userIds.split(',').map(Number) : userIds;
        const branchArr = typeof branch === 'string' ? branch.split(',').map(Number) : branch;

        const page = parseInt(start);
        const limit = parseInt(length);
        const sortBy = order_by;
        const sortOrder = order_dir;

        const { data, total } = await Project.datatableProjectReports({
            page, limit, sortBy, sortOrder, search,
            userIds: userIdsArr,
            branch: branchArr,
            startdate,
            enddate,
            status
        });
        const totalPages = Math.ceil(total / limit);
        const paginationMeta = {
            total,
            page,
            limit,
            totalPages
        };
        return res.status(200).json({
            status: 200,
            success: true,
            message: 'Project reports fetched successfully',
            data,
            total,
            pagination: paginationMeta
        });
    } catch (error) {
        return res.status(500).json({
            status: 500,
            success: false,
            message: 'Error fetching datatable project reports',
            error: error.message
        });
    }
};


