import { ProjectAssignee } from '../models/projectassignee.js';

export const createAssignee = async (req, res) => {
    try {
        if (!Array.isArray(req.body.user_id)) {
            return res.status(400).json({
                status: 400,
                message: 'user_id must be an array'
            });
        }

        const assigneeIds = await ProjectAssignee.create(req.body, req.user.id);
        const assignees = await Promise.all(
            assigneeIds.map(id => ProjectAssignee.findById(id))
        );
        
        res.status(201).json({
            status: 201,
            message: 'Project assignees created successfully',
            assignees
        });
    } catch (error) {
        console.error('Create assignee error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to create project assignees'
        });
    }
};

export const updateAssignee = async (req, res) => {
    try {
        const { id } = req.params;
        await ProjectAssignee.update(id, req.body);
        const assignee = await ProjectAssignee.findById(id);

        res.json({
            status: 200,
            message: 'Project assignee updated successfully',
            assignee
        });
    } catch (error) {
        console.error('Update assignee error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to update project assignee'
        });
    }
};

export const deleteAssignee = async (req, res) => {
    try {
        const { id } = req.params;
        await ProjectAssignee.softDelete(id);

        res.json({
            status: 200,
            message: 'Project assignee deleted successfully'
        });
    } catch (error) {
        console.error('Delete assignee error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to delete project assignee'
        });
    }
};
export const listgetAssignees = async (req, res) => {
    try {
        
        const { project_id } = req.body;
        
        if (!project_id) {
            return res.status(400).json({
                status: 400,
                message: 'Project ID is required'
            });
        }

        const assignees = await ProjectAssignee.list(project_id);
        
        res.json({
            status: 200,
            message: 'Project assignees retrieved successfully',
            assignees
        });
    } catch (error) {
        console.error('List assignees error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to retrieve project assignees'
        });
    }
};
export const listAssignees = async (req, res) => {
    try {
        
        const { project_id } = req.params;
        
        if (!project_id) {
            return res.status(400).json({
                status: 400,
                message: 'Project ID is required'
            });
        }

        const assignees = await ProjectAssignee.list(project_id);
        
        res.json({
            status: 200,
            message: 'Project assignees retrieved successfully',
            assignees
        });
    } catch (error) {
        console.error('List assignees error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to retrieve project assignees'
        });
    }
};