import { Role } from '../models/role.js';

export const createRole = async (req, res) => {
    try {
        const roleId = await Role.create(req.body);
        const role = await Role.findById(roleId);
        
        res.status(201).json({
            status: 201,
            message: 'Role created successfully',
            role
        });
    } catch (error) {
        console.error('Create role error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to create role'
        });
    }
};

export const updateRole = async (req, res) => {
    try {
        const { id } = req.params;
        await Role.update(id, req.body);
        const role = await Role.findById(id);

        res.json({
            status: 200,
            message: 'Role updated successfully',
            role
        });
    } catch (error) {
        console.error('Update role error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to update role'
        });
    }
};

export const deleteRole = async (req, res) => {
    try {
        const { id } = req.params;
        await Role.softDelete(id);

        res.json({
            status: 200,
            message: 'Role deleted successfully'
        });
    } catch (error) {
        console.error('Delete role error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to delete role'
        });
    }
};

export const listRoles = async (req, res) => {
    try {
        const roles = await Role.list();
        
        res.json({
            status: 200,
            message: 'Roles retrieved successfully',
            roles
        });
    } catch (error) {
        console.error('List roles error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to retrieve roles'
        });
    }
};