import { db } from "../utils/database.js";
import { findTasksRolewise, finddatatableTasksRolewise } from "../models/taskrolewisemodel.js";
import { Task } from '../models/task.js';

export const getTasksRolewise = async (req, res) => {
    try {
        console.log("getTasksRolewise called", req.user, req.query);

        if (!req.user || !req.user.id) {
            console.error("No user or user.id in req.user! Check your authentication middleware.");
            return res.status(401).json({ status: 401, success: false, message: "Unauthorized: No user info" });
        }

        const userIdToFind = Number(req.user.id); // Ensure it's a number

        // Debug log
        console.log("Looking up user with id:", userIdToFind, typeof userIdToFind);

        // Fetch user details from DB to get roles_id and branch_id
        let userRows = await db.query(
            "SELECT id, roles_id, branch_id FROM users WHERE id = ?",
            [userIdToFind]
        );

        const user = userRows[0];
        if (!user) {
            console.error(`User not found in DB for id: ${userIdToFind}`);
            return res.status(404).json({ status: 404, success: false, message: "User not found" });
        }
        if (!user.roles_id) {
            console.error("No roles_id in user record!", user);
            return res.status(400).json({ status: 400, success: false, message: "User has no roles_id" });
        }

        const { start_date, end_date, project_id, tasksubcategory_id } = req.query;

        // Get user's role and scope
        let scopeRows = await db.query(
            "SELECT scope FROM roles WHERE id = ?",
            [user.roles_id]
        );
        const scope = scopeRows[0]?.scope || '';
        console.log("User Role Scope:", scope);

        const safeUserId = user.id !== undefined ? user.id : null;
        const safeBranchId = user.branch_id !== undefined ? user.branch_id : null;
        const safeStartDate = start_date !== undefined ? start_date : null;
        const safeEndDate = end_date !== undefined ? end_date : null;
        const safeProjectId = project_id !== undefined ? project_id : null;
        const safeTasksubcategoryId = tasksubcategory_id !== undefined ? tasksubcategory_id : null;

        const tasks = await findTasksRolewise({
            scope,
            userId: safeUserId,
            branchId: safeBranchId,
            startDate: safeStartDate,
            endDate: safeEndDate,
            projectId: safeProjectId,
            tasksubcategoryId: safeTasksubcategoryId
        });

        return res.status(200).json({
            status: 200,
            success: true,
            message: "Tasks list fetched successfully",
            data: tasks || []
        });
    } catch (error) {
        console.error("Controller error:", error);
        return res.status(500).json({
            status: 500,
            success: false,
            message: "Error fetching tasks",
            error: error.message
        });
    }
};

// export const datatabletasks = async (req, res) => {
//     try {
//         const {
//             start = 1,
//             length = 10,
//             order_by = 'created_at',
//             order_dir = 'DESC',
//             search = '',
//             start_date,
//             end_date
//         } = req.query;

//         const page = parseInt(start);
//         const limit = parseInt(length);
//         const sortBy = order_by;
//         const sortOrder = order_dir;

//         const { tasks, total } = await Task.datatableList({ page, limit, sortBy, sortOrder, search, start_date, end_date });
//         const totalPages = Math.ceil(total / limit);
//         const paginationMeta = {
//             total,
//             page,
//             limit,
//             totalPages
//         };
//         return res.status(200).json({
//             status: 200,
//             success: true,
//             message: 'Tasks list fetched successfully',
//             data: tasks,
//             total,
//             pagination: paginationMeta
//         });
//     } catch (error) {
//         return res.status(500).json({
//             status: 500,
//             success: false,
//             message: 'Error fetching datatable tasks',
//             error: error.message
//         });
//     }
// };
export const datatabletasks = async (req, res) => {
    try {
        const {
            start = 1,
            length = 10,
            order_by = 'created_at',
            order_dir = 'DESC',
            search = '',
            start_date,
            end_date,
            project_id,
            tasksubcategory_id
        } = req.query;

        const page = parseInt(start);
        const limit = parseInt(length);

        const { tasks, total } = await finddatatableTasksRolewise({
            page,
            limit,
            sortBy: order_by,
            sortOrder: order_dir,
            search,
            start_date,
            end_date,
            project_id,
            tasksubcategory_id
        });

        const totalPages = Math.ceil(total / limit);
        const paginationMeta = {
            total,
            page,
            limit,
            totalPages
        };

        return res.status(200).json({
            status: 200,
            success: true,
            message: 'Tasks list fetched successfully',
            data: tasks,
            total,
            pagination: paginationMeta
        });
    } catch (error) {
        return res.status(500).json({
            status: 500,
            success: false,
            message: 'Error fetching datatable tasks',
            error: error.message
        });
    }
 };