import { TaskSubcategory } from '../models/tasksubcategory.js';

export const createSubcategory = async (req, res) => {
    try {
        const subcategoryId = await TaskSubcategory.create(req.body);
        const subcategory = await TaskSubcategory.findById(subcategoryId);
        
        res.status(201).json({
            status: 201,
            message: 'Task subcategory created successfully',
            subcategory
        });
    } catch (error) {
        console.error('Create subcategory error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to create task subcategory'
        });
    }
};

export const updateSubcategory = async (req, res) => {
    try {
        const { id } = req.params;
        await TaskSubcategory.update(id, req.body);
        const subcategory = await TaskSubcategory.findById(id);

        res.json({
            status: 200,
            message: 'Task subcategory updated successfully',
            subcategory
        });
    } catch (error) {
        console.error('Update subcategory error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to update task subcategory'
        });
    }
};

export const deleteSubcategory = async (req, res) => {
    try {
        const { id } = req.params;
        await TaskSubcategory.softDelete(id);

        res.json({
            status: 200,
            message: 'Task subcategory deleted successfully'
        });
    } catch (error) {
        console.error('Delete subcategory error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to delete task subcategory'
        });
    }
};

export const listSubcategories = async (req, res) => {
    try {
        const subcategories = await TaskSubcategory.list();
        
        res.json({
            status: 200,
            message: 'Task subcategories retrieved successfully',
            subcategories
        });
    } catch (error) {
        console.error('List subcategories error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to retrieve task subcategories'
        });
    }
};

export const getByTaskType = async (req, res) => {
    try {
        const { tasktype_id } = req.params;

        if (!tasktype_id) {
            return res.json({
                code: 400,
                status: false,
                message: 'Task type ID is required'
            });
        }

        const subcategories = await TaskSubcategory.getByTaskType(tasktype_id);

        res.json({
            code: 200,
            status: true,
            message: 'Task subcategories retrieved successfully',
            response: {
                count: subcategories.length,
                subcategories: subcategories
            }
        });
    } catch (error) {
        console.error('Get task subcategories error:', error);
        res.json({
            code: 500,
            status: false,
            message: 'Failed to retrieve task subcategories',
            response: {
                count: 0,
                subcategories: []
            }
        });
    }
};

export const viewSubcategoryById = async (req, res) => {
    try {
        const { id } = req.params;
        if (!id) {
            return res.status(400).json({
                status: 400,
                message: 'Subcategory ID is required'
            });
        }

        const subcategory = await TaskSubcategory.findById(id);

        if (!subcategory) {
            return res.status(404).json({
                status: 404,
                message: 'Task subcategory not found'
            });
        }

        res.status(200).json({
            status: 200,
            message: 'Task subcategory retrieved successfully',
            subcategory
        });
    } catch (error) {
        console.error('View subcategory error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to retrieve task subcategory'
        });
    }
};