import { TaskType } from '../models/tasktype.js';

export const createTaskType = async (req, res) => {
    try {
        // Get the uploaded file path
        const iconPath = req.file ? req.file.path.replace(/\\/g, '/') : null;
        
        if (!iconPath) {
            return res.status(400).json({
                status: 400,
                message: 'Activity icon is required'
            });
        }

        const taskTypeData = {
            ...req.body,
            activity_icon: iconPath
        };

        const taskTypeId = await TaskType.create(taskTypeData);
        const taskType = await TaskType.findById(taskTypeId);
        
        res.status(201).json({
            status: 201,
            message: 'Task type created successfully',
            taskType
        });
    } catch (error) {
        console.error('Create task type error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to create task type'
        });
    }
};

export const updateTaskType = async (req, res) => {
    try {
        const { id } = req.params;
        
        // Get the current task type to check existing icon
        const existingTaskType = await TaskType.findById(id);
        if (!existingTaskType) {
            return res.status(404).json({
                status: 404,
                message: 'Task type not found'
            });
        }

        // Update icon path if new file is uploaded
        const iconPath = req.file ? req.file.path.replace(/\\/g, '/') : existingTaskType.activity_icon;

        const taskTypeData = {
            ...req.body,
            activity_icon: iconPath
        };

        await TaskType.update(id, taskTypeData);
        const taskType = await TaskType.findById(id);

        res.json({
            status: 200,
            message: 'Task type updated successfully',
            taskType
        });
    } catch (error) {
        console.error('Update task type error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to update task type'
        });
    }
};

export const deleteTaskType = async (req, res) => {
    try {
        const { id } = req.params;
        await TaskType.softDelete(id);

        res.json({
            status: 200,
            message: 'Task type deleted successfully'
        });
    } catch (error) {
        console.error('Delete task type error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to delete task type'
        });
    }
};

export const listTaskTypes = async (req, res) => {
    try {
        const taskTypes = await TaskType.list();
        
        res.json({
            status: 200,
            message: 'Task types retrieved successfully',
            taskTypes
        });
    } catch (error) {
        console.error('List task types error:', error);
        res.status(500).json({
            status: 500,
            message: 'Failed to retrieve task types'
        });
    }
};

export const getActiveTaskTypesExceptOne = async (req, res) => {
    try {
        const taskTypes = await TaskType.listActiveExceptOne();
        res.status(200).json({
            status: 200,
            success: true,
            data: taskTypes
        });
    } catch (error) {
        res.status(500).json({
            status: 500,
            success: false,
            message: 'Failed to fetch task types',
            error: error.message
        });
    }
};