import express from 'express';
import dotenv from 'dotenv';
import { setRoutes } from './routes/index.js';
import { db } from './utils/database.js';
import cors from 'cors';
import path from 'path';
import { fileURLToPath } from 'url';

dotenv.config();

const app = express();
const __filename = fileURLToPath(import.meta.url);
const __dirname = path.dirname(__filename);
app.use('/uploads', express.static(path.join(__dirname, '../uploads')));
app.use(cors('*'));
// Middleware
app.use(express.json());
app.use(express.urlencoded({ extended: true }));

// const { startAttendanceCron } = require('/corn/attendanceCron.js');
// startAttendanceCron();
import { startAttendanceCron,
  forcestopAttendanceCron
 } from './cron/attendanceCron.js';
startAttendanceCron();
forcestopAttendanceCron();

// Simulate __dirname


// Setup routes
setRoutes(app);

// Database connection and server start
const PORT = process.env.PORT || 3000;

async function startServer() {
    try {
        await db.connect();
        app.listen(PORT, () => {
            console.log(`Server running on http://localhost:${PORT}`);
            console.log(`Health check: http://localhost:${PORT}/api/health`);
        });
    } catch (error) {
        console.error('Failed to start server:', error);
        process.exit(1);
    }
}

startServer();