import jwt from 'jsonwebtoken';
import dotenv from 'dotenv';
import { db } from '../utils/database.js';
import { User } from '../models/user.js';

dotenv.config();

const verifyToken = (req, res, next) => {
    try {
        const authHeader = req.headers.authorization;
        if (!authHeader) {
            return res.status(401).json({
                status: 401,
                message: 'No token provided'
            });
        }

        const token = authHeader.split(' ')[1];
        if (!token) {
            return res.status(401).json({
                status: 401,
                message: 'Invalid token format'
            });
        }

        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        req.user = decoded;
        next();
    } catch (error) {
        return res.status(401).json({
            status: 401,
            message: 'Invalid or expired token'
        });
    }
};

export const validateDeviceToken = async (req, res, next) => {
    try {
        const deviceToken = req.header('device-token');
        const userId = req.user.id;

        // Get user's device token from database
        const query = `
            SELECT device_token 
            FROM users 
            WHERE id = ? AND active = 1
        `;
        const [user] = await db.query(query, [userId]);

        if (!user || user.device_token !== deviceToken) {
            return res.json({
                code: 401,
                status: false,
                message: "Device token mismatch. Please login again."
            });
        }

        next();
    } catch (error) {
        console.error('Device token validation error:', error);
        res.json({
            code: 500,
            status: false,
            message: 'Failed to validate device token'
        });
    }
};

export { verifyToken };