import { db } from '../utils/database.js';

export class AppVersion {
    static async getLatest() {
        const query = `
            SELECT *
            FROM appversions 
            ORDER BY id DESC 
            LIMIT 1
        `;
        
        const [version] = await db.query(query);
        return version;
    }

    static async updateMapKeys(webMapKey, androidMapKey, IOSMapKey) {
        const query = `
            UPDATE appversions 
            SET webMapKey = ?, androidMapKey = ?, IOSMapKey = ?, updated_at = NOW()
            ORDER BY id ASC 
            LIMIT 1
        `;
        
        return db.query(query, [webMapKey, androidMapKey, IOSMapKey]);
    }
}