import { db } from '../utils/database.js';

export class AttendanceConfig {
    static async getConfig() {
        const query = `
            SELECT *
            FROM attendanceconfigs 
            ORDER BY id DESC 
            LIMIT 1
        `;
        const [config] = await db.query(query);
        return config;
    }

    static async updateConfig(configData) {
        const query = `
            UPDATE attendanceconfigs 
            SET allow_branch = ?,
                allow_sitevisit = ?,
                allow_outside = ?,
                allow_outsideapproval = ?,
                allow_branchfirst_site = ?,
                allow_branchlast_site = ?,
                capture_time = ?,
                capture_km = ?,
                transport_mode_edit_bike = ?,
                allow_other_task_outside = ?,
                updated_at = NOW()
            WHERE id = ?
        `;

        return db.query(query, [
            configData.allow_branch,
            configData.allow_sitevisit,
            configData.allow_outside,
            configData.allow_outsideapproval,
            configData.allow_branchfirst_site,
            configData.allow_branchlast_site,
            configData.capture_time,
            configData.capture_km,
            configData.transport_mode_edit_bike,
            configData.allow_other_task_outside,
            configData.id
        ]);
    }
}