import { db } from '../utils/database.js';

export class AttendanceResetModel {
    static async resetPunchout(userId, date) {
        // Find the first matching attendance task
        const [task] = await db.query(
            `SELECT * FROM tasks WHERE user_id = ? AND start_date = ? AND checkout_at != '' AND tasktype_id = 1 LIMIT 1`,
            [userId, date]
        );
        if (!task) return null;
        // Reset punchout fields
        await db.query(
            `UPDATE tasks SET 
                checkout_at = NULL,
                checkout_lat = NULL,
                checkout_long = NULL,
                checkout_location = NULL,
                distance_travelled = NULL,
                transport_mode = NULL,
                claim_amount = NULL,
                status = 'Inprogress',
                updated_at = NOW()
             WHERE id = ?`,
            [task.id]
        );
        // Return the updated task
        const [updatedTask] = await db.query(`SELECT * FROM tasks WHERE id = ?`, [task.id]);
        return updatedTask;
    }
} 