import { db } from '../utils/database.js';

export class Branch {
    static async create(branchData) {
        const query = `
            INSERT INTO branches (
                branch_name, location, branch_lat, branch_long, 
                radius, status, created_at, updated_at
            ) VALUES (?, ?, ?, ?, ?, 1, NOW(), NOW())
        `;
        
        const result = await db.query(query, [
            branchData.branch_name,
            branchData.location,
            branchData.branch_lat,
            branchData.branch_long,
            branchData.radius
        ]);
        
        return result.insertId;
    }

    static async update(id, branchData) {
        const query = `
            UPDATE branches 
            SET branch_name = ?,
                location = ?,
                branch_lat = ?,
                branch_long = ?,
                radius = ?,
                updated_at = NOW()
            WHERE id = ? AND status = 1
        `;
        
        return db.query(query, [
            branchData.branch_name,
            branchData.location,
            branchData.branch_lat,
            branchData.branch_long,
            branchData.radius,
            id
        ]);
    }

    static async softDelete(id) {
        const query = `
            UPDATE branches 
            SET status = 0,
                updated_at = NOW() 
            WHERE id = ?
        `;
        return db.query(query, [id]);
    }

    static async findById(id) {
        const query = 'SELECT * FROM branches WHERE id = ? AND status = 1';
        const [branch] = await db.query(query, [id]);
        return branch;
    }

    static async list() {
        const query = 'SELECT * FROM branches WHERE status = 1 ORDER BY created_at DESC';
        return db.query(query);
    }
}