import { db } from '../utils/database.js';

export class Company {
    static async create(companyData, userId) {
        const query = `
            INSERT INTO companies (
                company_id, company_name, company_address,
                company_lat, company_long, radius, email,
                mobile_no, create_date, branch_id,
                status, created_at, updated_at
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW(), ?, 1, NOW(), NOW())
        `;
        
        const result = await db.query(query, [
             companyData.company_id ?? null,
    companyData.company_name ?? null,
    companyData.company_address ?? null,
    companyData.company_lat ?? null,
    companyData.company_long ?? null,
    companyData.radius ?? 200,
    companyData.email ?? null,
    companyData.mobile_no ?? null,
    companyData.branch_id ?? null
        ]);
        
        return result.insertId;
    }

    static async update(id, companyData) {
        const query = `
            UPDATE companies 
            SET company_id = ?,
                company_name = ?,
                company_address = ?,
                company_lat = ?,
                company_long = ?,
                radius = ?,
                email = ?,
                mobile_no = ?,
                branch_id = ?,
                updated_at = NOW()
            WHERE id = ? AND status = 1
        `;
        
        return db.query(query, [
            companyData.company_id,
            companyData.company_name,
            companyData.company_address,
            companyData.company_lat,
            companyData.company_long,
            companyData.radius,
            companyData.email,
            companyData.mobile_no,
            companyData.branch_id,
            id
        ]);
    }

    static async softDelete(id) {
        const query = `
            UPDATE companies 
            SET status = 0,
                updated_at = NOW() 
            WHERE id = ?
        `;
        return db.query(query, [id]);
    }

    static async findById(id) {
        const query = `
            SELECT c.*, b.branch_name 
            FROM companies c
            LEFT JOIN branches b ON c.branch_id = b.id
            WHERE c.id = ? AND c.status = 1
        `;
        const [company] = await db.query(query, [id]);
        return company;
    }

    static async list() {
        const query = `
            SELECT c.*, b.branch_name 
            FROM companies c
            LEFT JOIN branches b ON c.branch_id = b.id
            WHERE c.status = 1 
            ORDER BY c.created_at DESC
        `;
        return db.query(query);
    }

    static async checkCompanyIdExists(companyId, excludeId = null) {
        const query = `
            SELECT COUNT(*) as count 
            FROM companies 
            WHERE company_id = ? 
            AND status = 1
            ${excludeId ? 'AND id != ?' : ''}
        `;
        const params = excludeId ? [companyId, excludeId] : [companyId];
        const [result] = await db.query(query, params);
        
        // Fix: Properly access the count from query result
        return result?.count > 0;
    }
}