import { db } from '../utils/database.js';

export class ConveyanceConfig {
    static async list() {
        const query = `
            SELECT * 
            FROM conveyanceconfigs 
            ORDER BY id DESC
        `;
        return db.query(query);
    }

    static async update(id, configData) {
        const query = `
            UPDATE conveyanceconfigs 
            SET transport_mode = ?,
                conveyance_charge = ?,
                updated_at = NOW()
            WHERE id = ?
        `;

        return db.query(query, [
            configData.transport_mode,
            configData.conveyance_charge,
            id
        ]);
    }

    static async findById(id) {
        const query = `
            SELECT * 
            FROM conveyanceconfigs 
            WHERE id = ?
        `;
        const [config] = await db.query(query, [id]);
        return config;
    }
}