import { db } from '../utils/database.js';

export const FirebaseInbox = {
    create: async (data) => {
        const [result] = await db.query(
            `INSERT INTO firebaseinboxes 
                (user_id, category, message, action, trigger_date, trigger_time, read_status, project_id, task_id, created_at, updated_at)
             VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW())`,
            [
                data.user_id,
                data.category,
                data.message,
                data.action,
                data.trigger_date,
                data.trigger_time,
                data.read_status ?? 0,
                data.project_id,
                data.task_id
            ]
        );
        return result.insertId;
    },

    list: async (user_id) => {
        let query = 'SELECT * FROM firebaseinboxes';
        let params = [];
        if (user_id) {
            query += ' WHERE user_id = ?';
            params.push(user_id);
        }
        query += ' ORDER BY created_at DESC';
        let rows = await db.query(query, params);
        return rows;
    },

    update: async (id, read_status) => {
        await db.query(
            `UPDATE firebaseinboxes SET read_status = ?, updated_at = NOW() WHERE id = ?`,
            [read_status, id]
        );
    }
};