import { db } from '../utils/database.js';

export class Manager {
    static async list() {
        const query = `
            SELECT u.*, 
                   r.name as role_name,
                   ru.name as reporting_to_user_name
            FROM users u
            LEFT JOIN roles r ON u.roles_id = r.id
            LEFT JOIN users ru ON u.reporting_to = ru.id
            WHERE u.active = 1 AND u.roles_id = 4
            ORDER BY u.created_at DESC
        `;
        const users = await db.query(query);

        // Convert comma-separated branch_ids back to array and get branch details
        for (let user of users) {
            user.branch_id = user.branch_id ? user.branch_id.split(',').map(Number) : [];
            if (user.branch_id.length > 0) {
                const branchQuery = `
                    SELECT id, branch_name 
                    FROM branches 
                    WHERE FIND_IN_SET(id, ?)
                `;
                const branches = await db.query(branchQuery, [user.branch_id.join(',')]);
                user.branches = branches;
            } else {
                user.branches = [];
            }
        }

        return users;
    }

    static async findById(id) {
        const query = `
            SELECT u.*, r.name as role_name 
            FROM users u
            LEFT JOIN roles r ON u.roles_id = r.id
            WHERE u.id = ? AND u.active = 1 AND u.roles_id = 4
        `;
        const [user] = await db.query(query, [id]);
        
        if (user) {
            // Convert comma-separated branch_ids back to array
            user.branch_id = user.branch_id ? user.branch_id.split(',').map(Number) : [];
            
            // Get branch details
            if (user.branch_id.length > 0) {
                const branchQuery = `
                    SELECT id, branch_name 
                    FROM branches 
                    WHERE FIND_IN_SET(id, ?)
                `;
                const branches = await db.query(branchQuery, [user.branch_id.join(',')]);
                user.branches = branches;
            } else {
                user.branches = [];
            }
        }
        
        return user;
    }
}