import { db } from '../utils/database.js';

export class Product {
    static async create(data) {
        const query = `
            INSERT INTO products
            (name, internal_name, type, model, sku_no, specifications, 	installation_instructions, status, created_at, updated_at)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW())
        `;
        let result = await db.query(query, [
            data.name,
            data.internal_name,
            data.type,
            data.model,
            data.sku_no,
            data.specifications,
            data.installation_instructions,
            data.status || 1
        ]);
        return result.insertId;
    }

    static async update(id, data) {
        const query = `
            UPDATE products SET
                name = ?,
                internal_name = ?,
                type = ?,
                model = ?,
                sku_no = ?,
                specifications = ?,
                installation_instructions = ?,
                status = ?,
                updated_at = NOW()
            WHERE id = ?
        `;
        await db.query(query, [
            data.name,
            data.internal_name,
            data.type,
            data.model,
            data.sku_no,
            data.specifications,
            data.installation_instructions,
            data.status || 1,
            id
        ]);
    }

    static async findById(id) {
        let rows = await db.query('SELECT * FROM products WHERE id = ?', [id]);
        return rows[0] || null;
    }

    static async softDelete(id) {
        await db.query('UPDATE products SET status = 0, updated_at = NOW() WHERE id = ?', [id]);
    }

    static async list() {
        let rows = await db.query('SELECT * FROM products WHERE status = 1');
        return rows;
    }
}