import { db } from '../utils/database.js';

export async function getUserProfile(userId) {
    try {
        // Get user with role and reporting info
        let userRows = await db.query(
            `SELECT u.*, r.name as role_name, ur.name as reporting_to_name
             FROM users u
             LEFT JOIN roles r ON u.roles_id = r.id
             LEFT JOIN users ur ON u.reporting_to = ur.id
             WHERE u.id = ?`,
            [userId]
        );
        const user = userRows[0];

        // Get attendance config
        let attendanceRows = await db.query(
            `SELECT * FROM attendanceconfigs LIMIT 1`
        );
        const attendanceconfig = attendanceRows[0];

        // Get branch info
        let branch = null;
        if (user && user.branch_id) {
            let branchRows = await db.query(
                `SELECT * FROM branches WHERE id = ?`,
                [user.branch_id]
            );
            branch = branchRows[0];
        }

        return { user, attendanceconfig, branch };
    } catch (error) {
        throw error;
    }
}

export async function updateUserProfile({ id, profile_pic }) {
    try {
        // Fetch user
        let userRows = await db.query('SELECT * FROM users WHERE id = ?', [id]);
        const user = userRows[0];
        if (!user) return null;

        // Build update fields
        let updateFields = { profile_pic };

        // Build SET clause
        const setClause = Object.keys(updateFields).map(key => `${key} = ?`).join(', ');
        const values = Object.values(updateFields);

        await db.query(`UPDATE users SET ${setClause} WHERE id = ?`, [...values, id]);

        // Return updated user
        let updatedRows = await db.query('SELECT * FROM users WHERE id = ?', [id]);
        return updatedRows[0];
    } catch (error) {
        throw error;
    }
}