import { db } from '../utils/database.js';

export class ProjectModule {
    static async create(data) {
        const { name, description } = data;
        const [result] = await db.query(
            'INSERT INTO project_modules (name, description) VALUES (?, ?)',
            [name, description]
        );
        return { id: result.insertId, name, description };
    }

    static async getAll() {
        const [results] = await db.query('SELECT * FROM project_modules');
        return results;
    }

    static async getById(id) {
        const [results] = await db.query(
            'SELECT * FROM project_modules WHERE id = ?',
            [id]
        );
        return results[0];
    }

    static async update(id, data) {
        const { name, description } = data;
        const [result] = await db.query(
            'UPDATE project_modules SET name = ?, description = ? WHERE id = ?',
            [name, description, id]
        );
        return result.affectedRows > 0;
    }

    static async delete(id) {
        const [result] = await db.query(
            'DELETE FROM project_modules WHERE id = ?',
            [id]
        );
        return result.affectedRows > 0;
    }
}