import { db } from '../utils/database.js';
import axios from 'axios';
import { decrypt } from '../utils/encryption.js';

export class Task {
    static async generateTaskId(projectId) {
        const query = `
            SELECT COALESCE(MAX(CAST(SUBSTRING(taskid, 2) AS UNSIGNED)), 0) as max_id 
            FROM tasks 
            WHERE project_id = ?
        `;
        const [result] = await db.query(query, [projectId]);
        const nextId = (result.max_id || 0) + 1;
        return `${nextId.toString().padStart(4, '0')}`;
    }

    static async getProjectDetails(projectId) {
        const query = `
            SELECT customer_id as company_id, contact_id 
            FROM projects 
            WHERE id = ? AND status = 1
        `;
        const [result] = await db.query(query, [projectId]);
        return result;
    }

    /*static async create(data, userId) {
        try {
            let projectDetails = null;
            let taskId = null;
            let company_id = null;
            let contact_id = null;

            // For tasktype_id != 8, fetch project details and generate taskId
            if (data.tasktype_id != 8) {
                projectDetails = await this.getProjectDetails(data.project_id);
                if (!projectDetails) {
                    throw new Error('Project not found');
                }
                company_id = projectDetails.company_id;
                contact_id = projectDetails.contact_id;
                taskId = await this.generateTaskId(data.project_id);
            } else {
                // For tasktype_id == 8, project_id, company_id, contact_id are null, generate a generic taskId
                taskId = null; // or any other logic for unique taskId
            }

            // Determine status, checkin_at, start_date, and start_time based on tasktype_id
            let status = 'Open';
            let checkin_at = null;
            let start_date = data.start_date || null;
            let start_time = data.start_time || null;

            if (data.tasktype_id == 6) {
                status = 'Closed';
                checkin_at = new Date();
                const now = new Date();
                start_date = now.toISOString().slice(0, 10); // YYYY-MM-DD
                start_time = now.toTimeString().slice(0, 8); // HH:MM:SS
            }

            const query = `
                INSERT INTO tasks (
                    taskid, task, description, start_date, start_time,
                    project_id, tasktype_id, tasksubcategory_id, product_id, taskcategoryoption_id,
                    user_id, company_id, contact_id, created_date,
                    created_at, updated_at, status, checkin_at
                ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW(), NOW(), ?, ?)
            `;
            let result = await db.query(query, [
                taskId,
                data.task,
                data.description,
                start_date,
                start_time,
                data.tasktype_id == 8 ? null : data.project_id,
                data.tasktype_id,
                data.tasksubcategory_id || null,
                data.product_id || null,
                data.taskcategoryoption_id || null,
                userId,
                data.tasktype_id == 8 ? null : company_id,
                data.tasktype_id == 8 ? null : contact_id,
                status,
                checkin_at
            ]);
            // If the task is assigned to a user different from the creator
           
                try {
                    // Fetch assigned user's device token
                    const [userRow] = await db.query(
                        'SELECT device_token as token, name FROM users WHERE id = ? LIMIT 1',
                        [userId]
                    );
                    
                    // Fetch project details if this is a project-related task
                    let projectName = '';
                    let projectCode = '';
                    if (data.project_id) {
                        const [projectRow] = await db.query(
                            'SELECT project_id, project_name FROM projects WHERE id = ? LIMIT 1',
                            [data.project_id]
                        );
                        projectCode = projectRow ? projectRow.project_id : '';
                        projectName = projectRow ? projectRow.project_name : '';
                    }
                    
                    const deviceToken = userRow ? userRow.token : null;
                    
                    // Compose notification
                    const notificationTitle = 'New Task Created';
                    const notificationBody = data.project_id 
                        ? `You have been created a new task: ${data.task} for project ${projectCode} (${projectName})`
                        : `You have been created a new task: ${data.task}`;
                    
                    // Send Firebase push notification if deviceToken exists
                    if (deviceToken) {
                        const message = {
                            notification: {
                                title: notificationTitle,
                                body: notificationBody
                            },
                            token: deviceToken
                        };
                        try {
                            await admin.messaging().send(message);
                        } catch (err) {
                            console.error('Firebase push notification error:', err);
                        }
                    }
                    
                    // Insert into firebaseinboxes table
                    await db.query(
                        `INSERT INTO firebaseinboxes 
                            (user_id, category, message, action, trigger_date, trigger_time, read_status, project_id, task_id, created_at, updated_at)
                         VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW())`,
                        [
                            userId,
                            'Task Created',
                            notificationBody,
                            'created',
                            new Date().toISOString().slice(0, 10), // trigger_date (YYYY-MM-DD)
                            new Date().toISOString().slice(0, 19), // trigger_time (HH:MM:SS)
                            0, // unread
                            data.project_id || null,
                            taskId1
                        ]
                    );
                } catch (notificationError) {
                    console.error('Task notification error:', notificationError);
                    // Continue with task creation even if notification fails
                }
            return result.insertId;
            //return taskId;
            //return result.insertId;
        } catch (error) {
            console.error('Create task error:', error);
            throw error;
        }
    }*/
     static async create(data, userId) {
        try {
            let projectDetails = null;
            let taskId = null;
            let company_id = null;
            let contact_id = null;

            // For tasktype_id != 8, fetch project details and generate taskId
            if (data.tasktype_id != 8) {
                projectDetails = await this.getProjectDetails(data.project_id);
                if (!projectDetails) {
                    throw new Error('Project not found');
                }
                company_id = projectDetails.company_id;
                contact_id = projectDetails.contact_id;
                taskId = await this.generateTaskId(data.project_id);
            } else {
                // For tasktype_id == 8, project_id, company_id, contact_id are null, generate a generic taskId
                taskId = null; // or any other logic for unique taskId
            }

            // Determine status, checkin_at, start_date, and start_time based on tasktype_id
            let status = 'Open';
            let checkin_at = null;
            let start_date = data.start_date || null;
            let start_time = data.start_time || null;

            if (data.tasktype_id == 6) {
                status = 'Closed';
                checkin_at = new Date();
                const now = new Date();
                start_date = now.toISOString().slice(0, 10); // YYYY-MM-DD
                start_time = now.toTimeString().slice(0, 8); // HH:MM:SS
            }

            // Use assignee_id if provided, otherwise use userId
            const assignee_id = data.assignee_id || userId;

            const query = `
                INSERT INTO tasks (
                    taskid, task, description, start_date, start_time,
                    project_id, tasktype_id, tasksubcategory_id, product_id, taskcategoryoption_id,
                    user_id, company_id, contact_id, created_date,
                    created_at, updated_at, status, checkin_at
                ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW(), NOW(), ?, ?)
            `;

            let result = await db.query(query, [
                taskId,
                data.task,
                data.description,
                start_date,
                start_time,
                data.tasktype_id == 8 ? null : data.project_id,
                data.tasktype_id,
                data.tasksubcategory_id || null,
                data.product_id || null,
                data.taskcategoryoption_id || null,
                assignee_id,
                data.tasktype_id == 8 ? null : company_id,
                data.tasktype_id == 8 ? null : contact_id,
                status,
                checkin_at
            ]);
            // If the task is assigned to a user different from the creator
           
                try {
                    // Fetch assigned user's device token
                    const [userRow] = await db.query(
                        'SELECT device_token as token, name FROM users WHERE id = ? LIMIT 1',
                        [userId]
                    );
                    
                    // Fetch project details if this is a project-related task
                    let projectName = '';
                    let projectCode = '';
                    if (data.project_id) {
                        const [projectRow] = await db.query(
                            'SELECT project_id, project_name FROM projects WHERE id = ? LIMIT 1',
                            [data.project_id]
                        );
                        projectCode = projectRow ? projectRow.project_id : '';
                        projectName = projectRow ? projectRow.project_name : '';
                    }
                    
                    const deviceToken = userRow ? userRow.token : null;
                    
                    // Compose notification
                    const notificationTitle = 'New Task Created';
                    const notificationBody = data.project_id 
                        ? `You have been created a new task: ${data.task} for project ${projectCode} (${projectName})`
                        : `You have been created a new task: ${data.task}`;
                    
                    // Send Firebase push notification if deviceToken exists
                    if (deviceToken) {
                        const message = {
                            notification: {
                                title: notificationTitle,
                                body: notificationBody
                            },
                            token: deviceToken
                        };
                        try {
                            await admin.messaging().send(message);
                        } catch (err) {
                            console.error('Firebase push notification error:', err);
                        }
                    }
                    
                    // Insert into firebaseinboxes table
                    await db.query(
                        `INSERT INTO firebaseinboxes 
                            (user_id, category, message, action, trigger_date, trigger_time, read_status, project_id, task_id, created_at, updated_at)
                         VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW())`,
                        [
                            userId,
                            'Task Created',
                            notificationBody,
                            'created',
                            new Date().toISOString().slice(0, 10), // trigger_date (YYYY-MM-DD)
                            new Date().toISOString().slice(0, 19), // trigger_time (HH:MM:SS)
                            0, // unread
                            data.project_id || null,
                            taskId
                        ]
                    );
                } catch (notificationError) {
                    console.error('Task notification error:', notificationError);
                    // Continue with task creation even if notification fails
                }
            return result.insertId;
            //return taskId;
            //return result.insertId;
        } catch (error) {
            console.error('Create task error:', error);
            throw error;
        }
    }
    /*static async update(id, data) {
        try {
            const query = `
                UPDATE tasks 
                SET task = ?,
                    description = ?,
                    start_date = ?,
                    start_time = ?,
                    tasktype_id = ?,
                    tasksubcategory_id = ?,
                    product_id = ?,
                    updated_at = NOW()
                WHERE id = ?
            `;

            await db.query(query, [
                data.task,
                data.description,
                data.start_date,
                data.start_time,
                data.tasktype_id,
                data.tasksubcategory_id,
                data.product_id,
                id
            ]);

            return true;
        } catch (error) {
            console.error('Update task error:', error);
            throw error;
        }
    }*/
      static async update(id, data) {
        try {
            // Use assignee_id if provided, otherwise keep existing user_id
            const updateFields = [
                'task = ?',
                'description = ?',
                'start_date = ?',
                'start_time = ?',
                'tasktype_id = ?',
                'tasksubcategory_id = ?',
                'product_id = ?'
            ];
            
            const updateValues = [
                data.title,
                data.description,
                data.start_date,
                data.start_time,
                data.tasktype_id,
                data.tasksubcategory_id,
                data.product_id
            ];

            // Add assignee_id to update if provided
            if (data.assignee_id !== undefined) {
                updateFields.push('user_id = ?');
                updateValues.push(data.assignee_id);
            }

            updateFields.push('updated_at = NOW()');
            updateValues.push(id);

            const query = `
                UPDATE tasks 
                SET ${updateFields.join(', ')}
                WHERE id = ?
            `;

            await db.query(query, updateValues);

            return true;
        } catch (error) {
            console.error('Update task error:', error);
            throw error;
        }
    }

    static async getPreviousTask(userId, currentTaskId) {
        // Get today's date in YYYY-MM-DD format
        const today = new Date().toISOString().slice(0, 10);

        let rows = await db.query(
            `SELECT * FROM tasks 
             WHERE user_id = ? 
               AND DATE(checkin_at) = ? 
               AND id < ? 
               AND checkin_lat IS NOT NULL 
               AND checkin_long IS NOT NULL
             ORDER BY checkin_at DESC 
             LIMIT 1`,
            [userId, today, currentTaskId]
        );
        return rows && rows[0] ? rows[0] : null;
    }
    /*static async getNextTask(userId, currentTaskId) {
        const today = new Date().toISOString().slice(0, 10);

        let rows = await db.query(
            `SELECT * FROM tasks 
             WHERE user_id = ? 
               AND DATE(checkin_at) = ? 
               AND id > ? 
               AND checkin_lat IS NOT NULL 
               AND checkin_long IS NOT NULL
             ORDER BY checkin_at DESC 
             LIMIT 1`,
            [userId, today, currentTaskId]
        );
        console.log(today);
        return rows && rows[0] ? rows[0] : null;
    }*/
    static async getNextTask(userId, currentTaskId) {
    // Get today's date in YYYY-MM-DD format
    const today = new Date().toISOString().slice(0, 10);

    // First query: get the next task after currentTaskId
    let rows = await db.query(
        `SELECT * FROM tasks 
         WHERE user_id = ? 
           AND DATE(checkin_at) = ? 
           AND id > ? 
           AND checkin_lat IS NOT NULL 
           AND checkin_long IS NOT NULL
         ORDER BY checkin_at DESC 
         LIMIT 1`,
        [userId, today, currentTaskId]
    );

    // If no next task found, fallback to current task
    if (!rows || !rows[0]) {
        rows = await db.query(
            `SELECT * FROM tasks 
             WHERE user_id = ? 
               AND DATE(checkin_at) = ? 
               AND id = ? 
               AND checkin_lat IS NOT NULL 
               AND checkin_long IS NOT NULL
             ORDER BY checkin_at DESC 
             LIMIT 1`,
            [userId, today, currentTaskId]
        );

    }
    console.log(rows);
    return rows && rows[0] ? rows[0] : null;
}
    static async findById(taskId) {
        const [rows] = await db.query('SELECT * FROM tasks WHERE id = ?', [taskId]);
        return rows || null;
    }

    static async updateTaskStatus(taskId, updateData) {
        const fields = [];
        const values = [];
        for (const key in updateData) {
            fields.push(`${key} = ?`);
            values.push(updateData[key]);
        }
        values.push(taskId);
        const sql = `UPDATE tasks SET ${fields.join(', ')} WHERE id = ?`;
        await db.query(sql, values);
        
    }

    static async calculateDistance(lat1, lon1, lat2, lon2) {
        // Use Google Maps Distance Matrix API
        //const [appVersion] = await db.query('SELECT webMapKey FROM appversions ORDER BY id DESC LIMIT 1');
        //const encryptedKey = appVersion?.webMapKey;
        
        // if (!encryptedKey) {
        //     throw new Error('Google Maps API key not found');
        // }
        
        // Decrypt the key
        //const apiKey = decrypt(encryptedKey);
        console.log("task js checkin"+lat1);
        const apiKey = 'AIzaSyDBH0gZFTtc46hT_HqwSefTKxuZkEdi73U';
        const url = `https://maps.googleapis.com/maps/api/distancematrix/json?units=metric&origins=${lat1},${lon1}&destinations=${lat2},${lon2}&key=${apiKey}`;
        
        console.log("task js url"+url);
        const response = await axios.get(url);
        console.log(response);
        console.log("Distance in meters:", response.data.rows[0].elements[0].distance.value);
        const distance = response.data.rows[0].elements[0].distance.value; // in meters
        const distanceInKm = distance/1000;
        return distanceInKm;
        //return distance;
    }

    static async getUserDashboard(userId, date, deviceId) {
        // 1. Fetch all tasks for the user for the given date
        const tasksQuery = `
            SELECT 
                t.*, 
                tt.id as tasktype_id, tt.activity_id, tt.activity_name, tt.activity_icon,
                tt.allow_checkin_checkout, tt.allow_startdate_enddate, tt.show_calendar,
                tt.mark_completed, tt.allow_claim, tt.allow_edit, tt.totalquestion,
                tt.status as tasktype_status, tt.created_at as tasktype_created_at, tt.updated_at as tasktype_updated_at,
                p.id as project_id,p.customer_id, p.contact_id, p.customer_branch_id, p.customer_po, p.customer_po_value,
                p.start_date as project_start_date, p.closure_date, p.project_latitude, p.project_longitude, p.address as project_address,
                p.notes, p.payment_terms, p.ho_service_date, p.project_manager, p.package, p.created_by, p.status as project_status_value,
                p.project_status, p.created_at as project_created_at, p.updated_at as project_updated_at,
                c.company_id as company_id, c.company_name, c.company_address, c.company_lat, c.company_long, c.radius,
                c.email as company_email, c.mobile_no as company_mobile, c.create_date as company_create_date,
                c.external_id as company_branch_id, c.product_id as company_product_id,
                c.gps_coordinates as company_gps_coordinates, c.status as company_status,
                c.created_at as company_created_at, c.updated_at as company_updated_at,
                ct.id as contact_id, ct.contact_name, ct.email as contact_email, ct.mobile_no as contact_mobile
            FROM tasks t
            LEFT JOIN tasktypes tt ON t.tasktype_id = tt.id
            LEFT JOIN projects p ON t.project_id = p.id
            LEFT JOIN companies c ON p.customer_id = c.id
            LEFT JOIN contacts ct ON p.contact_id = ct.id
            WHERE t.tasktype_id IN(3,6,8) and t.user_id = ? AND DATE(t.start_date) = ?
            ORDER BY t.start_date, t.start_time
        `;
        let formattedTasks = await db.query(tasksQuery, [userId, date]);
console.log(formattedTasks);
        const tasks = formattedTasks.map(task => ({
            id: task.id,
            task: task.task,
            tasktype_id: task.tasktype_id,
            description: task.description,
            start_date: task.start_date,
            start_time: task.start_time,
            end_date: task.end_date,
            end_time: task.end_time,
            status: task.status,
            project: {
                project_id: task.project_id,
                customer_id: task.customer_id,
                contact_id: task.contact_id,
                customer_branch_id: task.customer_branch_id,
                customer_po: task.customer_po,
                customer_po_value: task.customer_po_value,
                start_date: task.project_start_date,
                closure_date: task.closure_date,
                project_latitude: task.project_latitude,
                project_longitude: task.project_longitude,
                address: task.project_address,
                notes: task.notes,
                payment_terms: task.payment_terms,
                ho_service_date: task.ho_service_date,
                project_manager: task.project_manager,
                package: task.package,
                created_by: task.created_by,
                status: task.project_status_value,
                project_status: task.project_status,
                created_at: task.project_created_at,
                updated_at: task.project_updated_at
            },
            company: {
                company_id: task.company_id,
                company_name: task.company_name,
                company_address: task.company_address,
                company_lat: task.company_lat,
                company_long: task.company_long,
                radius: task.radius,
                email: task.company_email,
                mobile_no: task.company_mobile,
                create_date: task.company_create_date,
                external_id: task.company_external_id,
                branch_id: task.company_branch_id,
                product_id: task.company_product_id,
                gps_coordinates: task.company_gps_coordinates,
                status: task.company_status,
                created_at: task.company_created_at,
                updated_at: task.company_updated_at
            },
            contact: {
                id: task.contact_id,
                name: task.contact_name,
                email: task.contact_email,
                mobile_no: task.contact_mobile
            },
            tasktype: {
                id: task.tasktype_id,
                activity_id: task.activity_id,
                activity_name: task.activity_name,
                activity_icon: task.activity_icon,
                allow_checkin_checkout: task.allow_checkin_checkout,
                allow_startdate_enddate: task.allow_startdate_enddate,
                show_calendar: task.show_calendar,
                mark_completed: task.mark_completed,
                allow_claim: task.allow_claim,
                allow_edit: task.allow_edit,
                totalquestion: task.totalquestion,
                status: task.tasktype_status,
                created_at: task.tasktype_created_at,
                updated_at: task.tasktype_updated_at
            }
        }));

        // Now formattedTasks contains the desired structure

        // 2. Fetch in-progress tasks for the user for the given date
        const inProgressQuery = `
            SELECT t.*
            FROM tasks t
            WHERE t.tasktype_id IN(3,6,8) and t.user_id = ? AND DATE(t.start_date) = ? AND t.status = 'Inprogress'
        `;
        let opentasklist = await db.query(inProgressQuery, [userId, date]);
        //let opentasklist=inProgressTasks;
        // 3. Fetch attendance config (assuming only one config row)
        console.log("open task list"+opentasklist);
        const [attendanceConfigRows] = await db.query(
            `SELECT * FROM attendanceconfigs LIMIT 1`
        );
        const attendanceConfig = attendanceConfigRows || null;

        // 4. Fetch logged-in user's assigned branch detail
        const [branchRows] = await db.query(
            `SELECT b.* FROM branches b
             INNER JOIN users u ON u.branch_id = b.id
             WHERE u.id = ? LIMIT 1`, [userId]
        );
        const branch = branchRows || null;

        // 5. Fetch user's registered device_id
        const [userRows] = await db.query(
            `SELECT device_id,change_password FROM users WHERE id = ? LIMIT 1`, [userId]
        );
        const userDeviceId = userRows?.device_id || null;
        console.log(userDeviceId);
        const change_password = userRows?.change_password || null;
        // 6. Check if any in-progress task exists
        const isCheckinCheckout = !opentasklist || opentasklist.length === 0 ? true : false;

        // 7. Check device_id match
        const isDeviceMatch = userDeviceId && userDeviceId === deviceId;
        //8.get attendance task
        const attendancetaskQuery = `
            SELECT t.*
            FROM tasks t
            WHERE t.tasktype_id=1 and t.user_id = ? AND DATE(t.start_date) = ?
        `;
        const [attendance] = await db.query(attendancetaskQuery, [userId, date]);
   
        return {
            tasks,
            opentasklist,
            attendanceConfig,
            branch,
            isCheckinCheckout,
            isDeviceMatch,
            attendance,
            change_password
        };
    }

    static async createAttendanceTasks() {
        try {
        //const date = new Date().toISOString().split('T')[0];
        const date = new Date().toLocaleDateString('en-CA', {
  timeZone: 'Asia/Kolkata'
});
        console.log(date); // e.g., "2025-10-25"
        // Get users (handle all possible return types)
        let userslist = await db.query(
            'SELECT id, name FROM users WHERE active = 1'
        );


        if (userslist.length === 0) {
            throw new Error('No eligible users found for attendance task creation');
        }

        const createdTasks = [];

        for (let i = 0; i < userslist.length; i++) {
            console.log(`ID: ${userslist[i].id}, Name: ${userslist[i].name}`);
           // console.log(user.id, user.name);
            const taskTitle = `Attendance ${userslist[i].name}-${date}`;
            const description = taskTitle;
            

           let result = await db.query(
                `INSERT INTO tasks 
                (task, description, start_date, start_time, end_date, end_time, user_id, status,created_date, created_at, updated_at,tasktype_id)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?,NOW(), NOW(), NOW(),1)`,
                [
                    taskTitle,
                    description,
                    date,
                    '09:00 AM',
                    date,
                    '06:00 PM',
                    userslist[i].id,
                    'Open'
                ]
            );
            // console.log("--------->", result);
            
            createdTasks.push({
                id: result.insertId,
                task: taskTitle,
                description,
                start_date: date,
                start_time: '09:00 AM',
                end_date: date,
                end_time: '06:00 PM',
                user_id: userslist[i].id,
                status: 'Open'
            });

        } 
        // console.log("create task ------------>", createdTasks);
        const response = {
            code: 200,
            status: true,
            message: "Attendance tasks created successfully",
            tasks: createdTasks
        }
        return response;
    }catch (error){
        throw new Error("Error: ", error)
    }
    }

    static async filterTasks(userId, filter, filter_by) {
         const date = new Date();
        // 1. Check open/inprogress task for checkin/checkout logic
        const openTaskQuery = `
            SELECT checkout_at
            FROM tasks
            WHERE tasktype_id IN (3,8)
            AND user_id = ?
            AND status = 'Inprogress'
            LIMIT 1
        `;
        const [openTaskRows] = await db.query(openTaskQuery, [userId]);
        let isCheckinCheckout = true;
        if (openTaskRows && openTaskRows.length > 0) {
            const openTask = openTaskRows[0];
            if (!openTask.checkout_at || openTask.checkout_at === "") {
                isCheckinCheckout = false;
            } else {
                isCheckinCheckout = false;
            }
        } else {
            isCheckinCheckout = true;
        }

        // 2. Attendance checkin/checkout logic
        let attendancecount = 0;
        let attendanceDate = date;
        if (!attendanceDate) {
            // Use today's date if not provided
            const now = new Date();
            attendanceDate = now.toISOString().split('T')[0];
        }
        const attendanceCheckQuery = `
            SELECT checkout_at
            FROM tasks
            WHERE tasktype_id = 1
            AND user_id = ?
            AND start_date = ?
            AND checkin_at IS NOT NULL
            LIMIT 1
        `;
        const [attendanceCheckRows] = await db.query(attendanceCheckQuery, [userId, attendanceDate]);
        if (attendanceCheckRows && attendanceCheckRows.length > 0) {
            const attendanceCheck = attendanceCheckRows[0];
            if (!attendanceCheck.checkout_at || attendanceCheck.checkout_at === "") {
                attendancecount = 1;
            } else {
                attendancecount = 2;
            }
        }
        const attendancetaskQuery = `
            SELECT t.*
            FROM tasks t
            WHERE t.tasktype_id=1 and t.user_id = ? AND DATE(t.start_date) = ?
        `;
        const [attendance] = await db.query(attendancetaskQuery, [userId, date]);
   
        // 3. Build filter query
        let whereClauses = ['t.user_id = ?'];
        let params = [userId];
        whereClauses.push('tasktype_id in(3,6,8)');
        if (filter && filter_by) {
            if (filter_by === 'company_id' && filter) {
                whereClauses.push('p.customer_id = ?');
                params.push(filter);
            } else if (filter_by === 'contacts' && filter) {
                whereClauses.push('p.contact_id = ?');
                params.push(filter);
            } else if (filter_by === 'status' && filter) {
                whereClauses.push('t.status = ?');
                params.push(filter);
            }
            else if (filter_by === 'start_date' && filter) {
                whereClauses.push('t.start_date = ?');
                params.push(filter);
            }
        }

        const tasksQuery = `
            SELECT 
                t.*, 
                tt.id as tasktype_id, tt.activity_id, tt.activity_name, tt.activity_icon,
                tt.allow_checkin_checkout, tt.allow_startdate_enddate, tt.show_calendar,
                tt.mark_completed, tt.allow_claim, tt.allow_edit, tt.totalquestion,
                tt.status as tasktype_status, tt.created_at as tasktype_created_at, tt.updated_at as tasktype_updated_at,
                p.id as project_id,p.customer_id, p.contact_id, p.customer_branch_id, p.customer_po, p.customer_po_value,
                p.start_date as project_start_date, p.closure_date, p.project_latitude, p.project_longitude, p.address as project_address,
                p.notes, p.payment_terms, p.ho_service_date, p.project_manager, p.package, p.created_by, p.status as project_status_value,
                p.project_status, p.created_at as project_created_at, p.updated_at as project_updated_at,
                c.company_id as company_id, c.company_name, c.company_address, c.company_lat, c.company_long, c.radius,
                c.email as company_email, c.mobile_no as company_mobile, c.create_date as company_create_date,
                c.external_id as company_branch_id, c.product_id as company_product_id,
                c.gps_coordinates as company_gps_coordinates, c.status as company_status,
                c.created_at as company_created_at, c.updated_at as company_updated_at,
                ct.id as contact_id, ct.contact_name, ct.email as contact_email, ct.mobile_no as contact_mobile
            FROM tasks t
            LEFT JOIN tasktypes tt ON t.tasktype_id = tt.id
            LEFT JOIN projects p ON t.project_id = p.id
            LEFT JOIN companies c ON p.customer_id = c.id
            LEFT JOIN contacts ct ON p.contact_id = ct.id
            WHERE ${whereClauses.join(' AND ')}
            ORDER BY t.start_time
        `;

        let rows = await db.query(tasksQuery, params);

        const tasks = rows.map(task => ({
            id: task.id,
            task: task.task,
            description: task.description,
            start_date: task.start_date,
            start_time: task.start_time,
            end_date: task.end_date,
            end_time: task.end_time,
            status: task.status,
            tasktype_id: task.tasktype_id,
            project: {
                project_id: task.project_id,
                customer_id: task.customer_id,
                contact_id: task.contact_id,
                customer_branch_id: task.customer_branch_id,
                customer_po: task.customer_po,
                customer_po_value: task.customer_po_value,
                start_date: task.project_start_date,
                closure_date: task.closure_date,
                project_latitude: task.project_latitude,
                project_longitude: task.project_longitude,
                address: task.project_address,
                notes: task.notes,
                payment_terms: task.payment_terms,
                ho_service_date: task.ho_service_date,
                project_manager: task.project_manager,
                package: task.package,
                created_by: task.created_by,
                status: task.project_status_value,
                project_status: task.project_status,
                created_at: task.project_created_at,
                updated_at: task.project_updated_at
            },
            company: {
                company_id: task.company_id,
                company_name: task.company_name,
                company_address: task.company_address,
                company_lat: task.company_lat,
                company_long: task.company_long,
                radius: task.radius,
                email: task.company_email,
                mobile_no: task.company_mobile,
                create_date: task.company_create_date,
                external_id: task.company_external_id,
                branch_id: task.company_branch_id,
                product_id: task.company_product_id,
                gps_coordinates: task.company_gps_coordinates,
                status: task.company_status,
                created_at: task.company_created_at,
                updated_at: task.company_updated_at
            },
            contact: {
                id: task.contact_id,
                name: task.contact_name,
                email: task.contact_email,
                mobile_no: task.contact_mobile
            },
            tasktype: {
                id: task.tasktype_id,
                activity_id: task.activity_id,
                activity_name: task.activity_name,
                activity_icon: task.activity_icon,
                allow_checkin_checkout: task.allow_checkin_checkout,
                allow_startdate_enddate: task.allow_startdate_enddate,
                show_calendar: task.show_calendar,
                mark_completed: task.mark_completed,
                allow_claim: task.allow_claim,
                allow_edit: task.allow_edit,
                totalquestion: task.totalquestion,
                status: task.tasktype_status,
                created_at: task.tasktype_created_at,
                updated_at: task.tasktype_updated_at
            }
        }));
        console.log(tasks);
        return {
            tasks,
            isCheckinCheckout,
            attendancecount,
            attendance
        };
    }

    static async viewConveyance(userId, userRoleId, date) {
        // 1. Get attendance config
        let attendanceConfigRows = await db.query('SELECT * FROM attendanceconfigs LIMIT 1');
        const attendanceConfig = attendanceConfigRows?.[0] || {};
        console.log(attendanceConfig);
        // 2. Determine transport_mode_edit_bike
        let transport_mode_edit_bike = false;
        if (userRoleId == 5) {
            transport_mode_edit_bike = true;
        } else {
            transport_mode_edit_bike = !!attendanceConfig.transport_mode_edit_bike;
        }
        
        // 3. Deviation logic
        let deviationsids = [];
        if (attendanceConfig.allow_outsideapproval === 1) {
            const [deviationCheckRows] = await db.query(
                `SELECT * FROM tasks WHERE user_id = ? AND tasktype_id = 1 AND DATE(checkin_at) = ? AND deviation_approval_status = 'Pending' LIMIT 1`,
                [userId, date]
            );
            const deviationCheck = deviationCheckRows?.[0];
            if (deviationCheck) {
                if (deviationCheck.deviation_in) {
                    const [firstVisitRows] = await db.query(
                        `SELECT id FROM tasks WHERE user_id = ? AND DATE(checkin_at) = ? AND tasktype_id != 1 ORDER BY checkin_at ASC LIMIT 1`,
                        [userId, date]
                    );
                    if (firstVisitRows?.[0]) deviationsids.push(firstVisitRows[0].id);
                }
                if (deviationCheck.deviation_out) {
                    const [lastVisitRows] = await db.query(
                        `SELECT id FROM tasks WHERE user_id = ? AND DATE(checkin_at) = ? AND tasktype_id = 1 AND status = 'Closed' LIMIT 1`,
                        [userId, date]
                    );
                    if (lastVisitRows?.[0]) deviationsids.push(lastVisitRows[0].id);
                }
            }
        }

        // 4. Build exclusion for deviations
        let notInClause = '';
        let notInParams = [];
        if (deviationsids.length > 0) {
            notInClause = `AND t.id NOT IN (${deviationsids.map(() => '?').join(',')})`;
            notInParams = deviationsids;
        }

        // 5. Fetch tasks with related data
        const tasksQuery = `
            SELECT 
                t.*, 
                tt.activity_name, tt.allow_checkin_checkout,
                c.company_name, c.company_address,
                ct.contact_name, ct.email as contact_email, ct.mobile_no as contact_mobile
            FROM tasks t
            LEFT JOIN tasktypes tt ON t.tasktype_id = tt.id
            LEFT JOIN companies c ON t.company_id = c.company_id
            LEFT JOIN contacts ct ON t.contact_id = ct.id
            WHERE t.user_id = ?
              AND DATE(t.checkin_at) = ?
              AND t.checkout_at IS NOT NULL
              AND t.tasktype_id IN (1,3,8)
              AND t.status = 'Closed'
              AND tt.allow_checkin_checkout = 1
              ${notInClause}
            ORDER BY t.checkin_at ASC
        `;
        let tasks = await db.query(tasksQuery, [userId, date, ...notInParams]);

        // 6. Format claim_created_date if present
        const conveyance = tasks.map(item => {
            if (item.claim_created_date) {
                const d = new Date(item.claim_created_date);
                item.claim_created_date = d.toISOString().slice(0, 10);
            }
            return item;
        });

        return {
            conveyance,
            transport_mode_edit_bike
        };
    }

    static async applyClaim({ task_id, transport_mode, amount, remarks, files, user_id }) {
        // 1. Validate task
        let taskRows = await db.query('SELECT * FROM tasks WHERE id = ?', [task_id]);
        if (taskRows.length==0) {
            return { error: 'Task not found' };
        }

        // 2. Update task claim fields
        let claim_amount = amount;
        let conveyance_charge = 0;
        if (transport_mode === 'Bike') {
            let configRows = await db.query(
                'SELECT conveyance_charge FROM conveyanceconfigs WHERE transport_mode = "Bike" LIMIT 1'
            );
            conveyance_charge = configRows[0]?.conveyance_charge || 0;
            claim_amount = taskRows[0].distance_travelled * conveyance_charge;
        }

        await db.query(
            `UPDATE tasks SET claim_status = 'Pending', transport_mode = ?, claim_created_date = NOW(), claim_amount = ?, claim_remarks = ? WHERE id = ?`,
            [transport_mode, claim_amount, remarks, task_id]
        );

        // 3. Insert into claims table
        let claimResult = await db.query(
            `INSERT INTO claims (task_id,project_id, created_date, transport_mode, amount, remarks, status, user_id)
             VALUES (?,?, CURDATE(), ?, ?, ?, 'Pending', ?)`,
            [task_id,taskRows[0].project_id, transport_mode, claim_amount, remarks, user_id]
        );
        const claim_id = claimResult.insertId;

        // 4. Handle file uploads (if any)
        if (files && files.length > 0) {
            for (const file of files) {
                // Save file info to claimuploads table
                await db.query(
                    `INSERT INTO claimuploads (task_id, claim_id, uploadfile) VALUES (?, ?, ?)`,
                    [task_id, claim_id, file.filename]
                );
            }
        }

        // 5. Fetch the claim record to return
        let claimRows = await db.query('SELECT * FROM claims WHERE id = ?', [claim_id]);
        return { claim: claimRows[0] };
    }

    static async reapplyClaim({ task_id, transport_mode, amount, remarks, files, user_id }) {
        // 1. Validate task
        let taskRows = await db.query('SELECT * FROM tasks WHERE id = ?', [task_id]);
        const task = taskRows[0];
        if (taskRows.length==0) {
            return { error: 'Task not found' };
        }

        // 2. Update task claim fields
        let claim_amount = amount;
        let conveyance_charge = 0;
        if (transport_mode === 'Bike') {
            let configRows = await db.query(
                'SELECT conveyance_charge FROM conveyanceconfigs WHERE transport_mode = "Bike" LIMIT 1'
            );
            conveyance_charge = configRows[0]?.conveyance_charge || 0;
            claim_amount = task.distance_travelled * conveyance_charge;
        }

        await db.query(
            `UPDATE tasks SET claim_status = 'Reapplied', transport_mode = ?, claim_created_date = NOW(), claim_amount = ?, claim_remarks = ? WHERE id = ?`,
            [transport_mode, claim_amount, remarks, task_id]
        );

        // 3. Insert into claims table
        let claimResult = await db.query(
            `INSERT INTO claims (task_id, project_id, created_date, transport_mode, amount, remarks, status, user_id)
             VALUES (?, ?, CURDATE(), ?, ?, ?, 'Reapplied', ?)`,
            [task_id, task.project_id, transport_mode, claim_amount, remarks, user_id]
        );
        const claim_id = claimResult.insertId;

        // 4. Handle file uploads (if any)
        if (files && files.length > 0) {
            for (const file of files) {
                await db.query(
                    `INSERT INTO claimuploads (task_id, claim_id, uploadfile) VALUES (?, ?, ?)`,
                    [task_id, claim_id, file.filename]
                );
            }
        }

        // 5. Fetch the claim record to return
        let claimRows = await db.query('SELECT * FROM claims WHERE id = ?', [claim_id]);
        return { claim: claimRows[0] };
    }

    static async getModeOfTransport(userId, userRoleId) {
        // 1. Get role info
        let roleRows = await db.query('SELECT eligible_transport FROM roles WHERE id = ?', [userRoleId]);
        const role = roleRows[0];
        if (!role) {
            return { notFound: true };
        }

        // 2. Get eligible transport modes
        const eligibletransport = role.eligible_transport || '';
        const modes = eligibletransport.split(',').map(m => m.trim()).filter(Boolean);

        // 3. Get conveyance config (for existence check)
        let transportRows = await db.query('SELECT * FROM conveyanceconfigs');
        if (!transportRows || transportRows.length === 0) {
            return { notFound: true };
        }

        return { modeoftransport: modes };
    }

    static async getApplyClaimList(userId, from_date, to_date) {
        // 1. Validate dates
        const start = new Date(from_date);
        const end = new Date(to_date);
        if (isNaN(start) || isNaN(end)) {
            return { error: 'Invalid date format' };
        }

        // 2. Get eligible tasks
        let tasks = await db.query(
            `SELECT c.start_date
             FROM tasks c
             LEFT JOIN tasktypes ts ON c.tasktype_id = ts.id
             WHERE ts.allow_claim = 1
               AND c.start_date BETWEEN ? AND ?
               AND c.user_id = ?
               AND c.status = 'Closed'
               AND c.claim_status = 'Pending'
             GROUP BY c.start_date`,
            [from_date, to_date, userId]
        );
console.log(tasks);
        // 3. Get claim count
        let claimCountRows = await db.query(
            `SELECT COUNT(*) as claimcount
             FROM tasks c
             LEFT JOIN tasktypes ts ON c.tasktype_id = ts.id
             WHERE ts.allow_claim = 1
               AND c.start_date BETWEEN ? AND ?
               AND c.user_id = ?
               AND c.status = 'Closed'
               AND c.claim_status = 'Pending'
             GROUP BY c.start_date`,
            [from_date, to_date, userId]
        );
        const claimapply = claimCountRows.length > 0 && claimCountRows[0].claimcount > 0;

        // 4. Get conveyance config
       let conveyanceConfigRows = await db.query('SELECT * FROM conveyanceconfigs LIMIT 1');
        const conveyance_charge = conveyanceConfigRows?.[0]?.conveyance_charge || 0;

        if (!tasks || tasks.length === 0) {
            return { notExists: true };
        }

        // 5. Get attendance config
        let attendanceConfigRows = await db.query('SELECT * FROM attendanceconfigs LIMIT 1');
        const attendanceConfig = attendanceConfigRows?.[0] || {};

        // 6. For each date, calculate distance, amount, timespent
        let conveyances = [];
        for (const task of tasks) {
            const date = task.start_date;
            let deviationsids = [];

            if (attendanceConfig.allow_outsideapproval === 1) {
                let deviationCheckRows = await db.query(
                    `SELECT * FROM tasks WHERE user_id = ? AND DATE(checkin_at) = ? AND tasktype_id = 1 AND deviation_approval_status = 'Pending' LIMIT 1`,
                    [userId, date]
                );
                const deviationCheck = deviationCheckRows?.[0];
                if (deviationCheck) {
                    if (deviationCheck.deviation_in) {
                        let firstVisitRows = await db.query(
                            `SELECT id FROM tasks WHERE user_id = ? AND DATE(checkin_at) = ? AND tasktype_id != 1 ORDER BY checkin_at ASC LIMIT 1`,
                            [userId, date]
                        );
                        if (firstVisitRows?.[0]) deviationsids.push(firstVisitRows[0].id);
                    }
                    if (deviationCheck.deviation_out) {
                        let lastVisitRows = await db.query(
                            `SELECT id FROM tasks WHERE user_id = ? AND DATE(checkin_at) = ? AND tasktype_id = 1 AND status = 'Closed' LIMIT 1`,
                            [userId, date]
                        );
                        if (lastVisitRows?.[0]) deviationsids.push(lastVisitRows[0].id);
                    }
                }
            }

            // Calculate distance
            let distanceRows = await db.query(
                `SELECT SUM(t.distance_travelled) as distance
                 FROM tasks t
                 LEFT JOIN tasktypes tt ON t.tasktype_id = tt.id
                 WHERE t.user_id = ?
                   AND DATE(t.checkin_at) = ?
                   AND t.status = 'Closed'
                   AND tt.allow_checkin_checkout = 1
                   ${notInClause}`,
                [userId, date, ...notInParams]
            );
            const distance = distanceRows?.[0]?.distance || 0;

            // Calculate claim amount
            let claimAmountRows = await db.query(
                `SELECT SUM(t.claim_amount) as amount
                 FROM tasks t
                 LEFT JOIN tasktypes tt ON t.tasktype_id = tt.id
                 WHERE t.user_id = ?
                   AND DATE(t.checkin_at) = ?
                   AND t.status = 'Closed'
                   AND tt.allow_checkin_checkout = 1
                   ${notInClause}`,
                [userId, date, ...notInParams]
            );
            const amount = claimAmountRows?.[0]?.amount || 0;

            // Calculate timespent
            let timespentRows = await db.query(
                `SELECT SUM(t.time_spent) as timespent
                 FROM tasks t
                 LEFT JOIN tasktypes tt ON t.tasktype_id = tt.id
                 WHERE t.user_id = ?
                   AND DATE(t.checkin_at) = ?
                   AND t.status = 'Closed'
                   AND tt.allow_checkin_checkout = 1
                   ${notInClause}`,
                [userId, date, ...notInParams]
            );
            const timespent = timespentRows?.[0]?.timespent || 0;

            conveyances.push({
                conveyance_date: date,
                distance,
                amount,
                timespent
            });
        }

        return {
            conveyance: conveyances,
            claimapply
        };
    }

    static async applyClaimBulk(userId, from_date, to_date) {
        // 1. Get attendance config
        let attendanceConfigRows = await db.query('SELECT * FROM attendanceconfigs LIMIT 1');
        const attendanceConfig = attendanceConfigRows?.[0] || {};

        const start = from_date;
        const end = to_date;

        let deviationsids = [];

        // 2. Deviation logic
        if (attendanceConfig.allow_outsideapproval === 1) {
            let deviationChecks = await db.query(
                `SELECT * FROM tasks WHERE user_id = ? AND start_date BETWEEN ? AND ? AND tasktype_id = 1 AND deviation_approval_status = 'Pending'`,
                [userId, start, end]
            );
            if (deviationChecks && deviationChecks.length > 0) {
                for (const deviationcheck of deviationChecks) {
                    const date = deviationcheck.start_date;
                    if (deviationcheck.deviation_in) {
                        let firstVisitRows = await db.query(
                            `SELECT id FROM tasks WHERE user_id = ? AND start_date = ? AND tasktype_id != 1 ORDER BY checkin_at ASC LIMIT 1`,
                            [userId, date]
                        );
                        if (firstVisitRows?.[0]) deviationsids.push(firstVisitRows[0].id);
                    }
                    if (deviationcheck.deviation_out) {
                        let lastVisitRows = await db.query(
                            `SELECT id FROM tasks WHERE user_id = ? AND DATE(checkin_at) = ? AND tasktype_id = 1 AND status = 'Closed' LIMIT 1`,
                            [userId, date]
                        );
                        if (lastVisitRows?.[0]) deviationsids.push(lastVisitRows[0].id);
                    }
                }
            }
        }

        // 3. Fetch tasks to apply claim
        let tasksQuery = `
            SELECT c.*
            FROM tasks c
            LEFT JOIN tasktypes ts ON c.tasktype_id = ts.id
            WHERE ts.allow_claim = 1
              AND c.start_date BETWEEN ? AND ?
              AND c.user_id = ?
              AND c.status = 'Closed'
        `;
        let params = [start, end, userId];
        if (deviationsids.length > 0) {
            tasksQuery += ` AND c.id NOT IN (${deviationsids.map(() => '?').join(',')})`;
            params = params.concat(deviationsids);
        }
        let tasks = await db.query(tasksQuery, params);

        if (!tasks || tasks.length === 0) {
            return { notExists: true };
        }

        // 4. Update claim_status and claim_created_date for each task
        for (const task of tasks) {
            await db.query(
                `UPDATE tasks SET claim_status = 'Applied', claim_created_date = NOW() WHERE id = ?`,
                [task.id]
            );
        }

        return { tasks };
    }

    static async getClaimHistory(userId, from_date, to_date) {
        let tasks = [], completedtasks = [], rejectedtasks = [];
        let params = [userId];
        let dateFilter = '';
        if (from_date && to_date) {
            dateFilter = 'AND c.start_date BETWEEN ? AND ?';
            params.push(from_date, to_date);
        }

        // Pending/approved/reapplied claims
        let pendingRows = await db.query(
            `SELECT c.* FROM tasks c
         LEFT JOIN tasktypes ts ON c.tasktype_id = ts.id
         WHERE ts.allow_claim = 1
           AND c.user_id = ?
           AND c.status = 'Closed'
           AND c.claim_status IN ('Applied','Approved','Reapplied')
           ${dateFilter}`,
            params
        );

        // Completed claims
        let completedRows = await db.query(
            `SELECT c.* FROM tasks c
         LEFT JOIN tasktypes ts ON c.tasktype_id = ts.id
         WHERE ts.allow_claim = 1
           AND c.user_id = ?
           AND c.status = 'Closed'
           AND c.claim_status = 'Completed'
           ${dateFilter}`,
            params
        );

        // Rejected claims
        let rejectedRows = await db.query(
            `SELECT c.* FROM tasks c
         LEFT JOIN tasktypes ts ON c.tasktype_id = ts.id
         WHERE ts.allow_claim = 1
           AND c.user_id = ?
           AND c.status = 'Closed'
           AND c.claim_status IN ('Rejected','Finance Rejected')
           ${dateFilter}`,
            params
        );

        tasks = pendingRows || [];
        completedtasks = completedRows || [];
        rejectedtasks = rejectedRows || [];

        if (tasks.length !== 0 || completedtasks.length !== 0 || rejectedtasks.length !== 0) {
            return {
                pendingclaim: tasks,
                completedclaim: completedtasks,
                rejectedclaim: rejectedtasks
            };
        } else {
            return null;
        }
    }

    static async addTaskNote({ project_id, task_id, user_id, notes, file }) {
        try {
            let file_name = null;
            let file_path = null;
            if (file) {
                file_name = file.originalname;
                file_path = file.filename; // multer stores the filename
            }

            const query = `
                INSERT INTO tasknotes
                (project_id, task_id, user_id, notes, file_name, file, create_date, created_at, updated_at)
                VALUES (?, ?, ?, ?, ?, ?, NOW(), NOW(), NOW())
            `;
            let result = await db.query(query, [
                project_id,
                task_id,
                user_id,
                notes,
                file_name,
                file_path
            ]);

            // Fetch the task detail to include in the response
            let taskRows = await db.query('SELECT * FROM tasks WHERE id = ?', [task_id]);
            const task = taskRows && taskRows[0] ? taskRows[0] : null;

            return { id: result.insertId, task };
        } catch (error) {
            console.error('Add task note error:', error);
            throw error;
        }
    }
    
        static async datatableList({ page = 1, limit = 10, sortBy = 'created_at', sortOrder = 'DESC', search = '', start_date, end_date }) {
        const allowedSortFields = ['created_at', 'task', 'taskid', 'status'];
        const validSortBy = allowedSortFields.includes(sortBy) ? sortBy : 'created_at';
        const validSortOrder = sortOrder && sortOrder.toUpperCase() === 'ASC' ? 'ASC' : 'DESC';
        const pageNum = parseInt(page);
        const limitNum = parseInt(limit);
        const offset = (pageNum - 1) * limitNum;

        let baseQuery = `SELECT t.*, u.emp_id, u.name, tt.activity_name AS tasktype_name, p.project_id AS project_code, p.project_name, c.company_name AS customer_name, ct.contact_name AS contact_name FROM tasks t LEFT JOIN users u ON t.user_id = u.id LEFT JOIN tasktypes tt ON t.tasktype_id = tt.id LEFT JOIN projects p ON t.project_id = p.id LEFT JOIN companies c ON p.customer_id = c.id LEFT JOIN contacts ct ON p.contact_id = ct.id WHERE t.tasktype_id != 1`;
        let params = [];

        // Date filter
        if (start_date && end_date) {
            baseQuery += ` AND DATE(t.created_at) BETWEEN ? AND ? `;
            params.push(start_date, end_date);
        } else if (start_date) {
            baseQuery += ` AND DATE(t.created_at) = ? `;
            params.push(start_date);
        } else if (end_date) {
            baseQuery += ` AND DATE(t.created_at) = ? `;
            params.push(end_date);
        }

        if (search && search.trim()) {
            const likeSearch = `%${search.trim()}%`;
            baseQuery += ` AND (t.task LIKE ? OR t.taskid LIKE ? OR p.project_name LIKE ? OR p.project_id LIKE ? OR c.company_name LIKE ? OR u.name LIKE ? OR u.emp_id LIKE ? OR tt.activity_name LIKE ? OR ct.contact_name LIKE ?)`;
            params.push(likeSearch, likeSearch, likeSearch, likeSearch, likeSearch, likeSearch, likeSearch, likeSearch, likeSearch);
        }

        // Get total count
        const countQuery = baseQuery.replace(/^SELECT t\.\*, u\.emp_id, u\.name, tt\.activity_name AS tasktype_name, p\.project_id AS project_code, p\.project_name, c\.company_name AS customer_name, ct\.contact_name AS contact_name/, 'SELECT COUNT(*) as total');
        const countResult = await db.query(countQuery, params);
        const total = countResult[0]?.total || 0;

        // Add ORDER BY, LIMIT, OFFSET
        baseQuery += ` ORDER BY t.${validSortBy} ${validSortOrder} LIMIT ? OFFSET ?`;
        params.push(limitNum, offset);

        const tasks = await db.query(baseQuery, params);
        return { tasks, total };
    }


    static async financeClaimUpdate({ claimIds, status, remarks, financeApprovedBy }) {
        if (!Array.isArray(claimIds) || claimIds.length === 0) {
            throw new Error('No claim selected.');
        }
        const finance_approved_date = new Date().toISOString().slice(0, 10);
        for (const claimId of claimIds) {
            await db.query(
                `UPDATE tasks SET 
                    claim_status = ?, 
                    claim_approved_remarks = ?, 
                    finance_approved_date = ?, 
                    finance_approved_by = ? 
                 WHERE id = ?`,
                [status, remarks, finance_approved_date, financeApprovedBy, claimId]
            );

            try {
                // Get task and user information
                const [taskRow] = await db.query(
                    `SELECT t.*, u.id as user_id, u.device_token as token, p.project_id, p.project_name 
                     FROM tasks t 
                     LEFT JOIN users u ON t.user_id = u.id
                     LEFT JOIN projects p ON t.project_id = p.id
                     WHERE t.id = ?`,
                    [claimId]
                );
                
                if (!taskRow) continue;
                
                const userId = taskRow.user_id;
                const deviceToken = taskRow.token;
                const projectId = taskRow.project_id;
                const projectName = taskRow.project_name || '';
                const projectCode = taskRow.project_id || '';
                const taskName = taskRow.task || 'Task';
                
                // Compose notification based on status
                let notificationTitle, notificationBody, action;
                
                if (status === 'Finance Approved') {
                    notificationTitle = 'Finance Approval';
                    notificationBody = projectId 
                        ? `Your claim for task "${taskName}" in project ${projectCode} (${projectName}) has been approved by finance.`
                        : `Your claim for task "${taskName}" has been approved by finance.`;
                    action = 'finance_approved';
                } else if (status === 'Finance Rejected') {
                    notificationTitle = 'Finance Rejection';
                    notificationBody = projectId 
                        ? `Your claim for task "${taskName}" in project ${projectCode} (${projectName}) has been rejected by finance. Reason: ${remarks || 'Not specified'}`
                        : `Your claim for task "${taskName}" has been rejected by finance. Reason: ${remarks || 'Not specified'}`;
                    action = 'finance_rejected';
                } else if (status === 'Completed') {
                    notificationTitle = 'Claim Completed';
                    notificationBody = projectId 
                        ? `Your claim for task "${taskName}" in project ${projectCode} (${projectName}) has been completed.`
                        : `Your claim for task "${taskName}" has been completed.`;
                    action = 'completed';
                } else {
                    notificationTitle = 'Finance Claim Update';
                    notificationBody = projectId 
                        ? `Your claim for task "${taskName}" in project ${projectCode} (${projectName}) status has been updated to ${status} by finance.`
                        : `Your claim for task "${taskName}" status has been updated to ${status} by finance.`;
                    action = 'finance_updated';
                }
                
                // Send Firebase push notification if deviceToken exists
                if (deviceToken) {
                    const message = {
                        notification: {
                            title: notificationTitle,
                            body: notificationBody
                        },
                        token: deviceToken
                    };
                    try {
                        // Import admin from firebaseAdmin.js
                       
                        await admin.messaging().send(message);
                    } catch (err) {
                        console.error('Firebase push notification error:', err);
                    }
                }
                
                // Insert into firebaseinboxes table
                await db.query(
                    `INSERT INTO firebaseinboxes 
                        (user_id, category, message, action, trigger_date, trigger_time, read_status, project_id, task_id, created_at, updated_at)
                     VALUES (?, ?, ?, ?, ?, NOW(), ?, ?, ?, NOW(), NOW())`,
                    [
                        userId,
                        'Finance Claim Update',
                        notificationBody,
                        action,
                        new Date().toISOString().slice(0, 10), // trigger_date (YYYY-MM-DD)
                        new Date().toISOString().slice(0, 19), // trigger_time (HH:MM:SS)
                        projectId || null,
                        claimId
                    ]
                );
            } catch (notificationError) {
                console.error('Finance claim notification error:', notificationError);
                // Continue with finance claim update even if notification fails
            }
            // Optionally: handle notification logic here if needed
        }
        return true;
    }

// ...existing code...
    static async claimUpdate({ claimIds, status, remarks, approvedBy }) {
        if (!Array.isArray(claimIds) || claimIds.length === 0) {
            throw new Error('No claim selected.');
        }
        const approved_date = new Date().toISOString().slice(0, 10);
        for (const claimId of claimIds) {
            // Update the task claim status and remarks
            await db.query(
                `UPDATE tasks SET 
                    claim_status = ?, 
                    claim_approved_remarks = ?, 
                    approved_date = ?, 
                    approved_by = ? 
                 WHERE id = ?`,
                [status, remarks, approved_date, approvedBy, claimId]
            );
            try {
                // Get task and user information
                const [taskRow] = await db.query(
                    `SELECT t.*, u.id as user_id, u.device_token as token, p.project_id, p.project_name 
                     FROM tasks t 
                     LEFT JOIN users u ON t.user_id = u.id
                     LEFT JOIN projects p ON t.project_id = p.id
                     WHERE t.id = ?`,
                    [claimId]
                );
                
                if (!taskRow) continue;
                
                const userId = taskRow.user_id;
                const deviceToken = taskRow.token;
                const projectId = taskRow.project_id;
                const projectName = taskRow.project_name || '';
                const projectCode = taskRow.project_id || '';
                const taskName = taskRow.task || 'Task';
                
                // Compose notification based on status
                let notificationTitle, notificationBody, action;
                
                if (status === 'Approved') {
                    notificationTitle = 'Claim Approved';
                    notificationBody = projectId 
                        ? `Your claim for task "${taskName}" in project ${projectCode} (${projectName}) has been approved.`
                        : `Your claim for task "${taskName}" has been approved.`;
                    action = 'approved';
                } else if (status === 'Rejected') {
                    notificationTitle = 'Claim Rejected';
                    notificationBody = projectId 
                        ? `Your claim for task "${taskName}" in project ${projectCode} (${projectName}) has been rejected. Reason: ${remarks || 'Not specified'}`
                        : `Your claim for task "${taskName}" has been rejected. Reason: ${remarks || 'Not specified'}`;
                    action = 'rejected';
                } else {
                    notificationTitle = 'Claim Status Updated';
                    notificationBody = projectId 
                        ? `Your claim for task "${taskName}" in project ${projectCode} (${projectName}) status has been updated to ${status}.`
                        : `Your claim for task "${taskName}" status has been updated to ${status}.`;
                    action = 'updated';
                }
                
                // Send Firebase push notification if deviceToken exists
                if (deviceToken) {
                    const message = {
                        notification: {
                            title: notificationTitle,
                            body: notificationBody
                        },
                        token: deviceToken
                    };
                    try {
                      
                        await admin.messaging().send(message);
                    } catch (err) {
                        console.error('Firebase push notification error:', err);
                    }
                }
                
                // Insert into firebaseinboxes table
                await db.query(
                    `INSERT INTO firebaseinboxes 
                        (user_id, category, message, action, trigger_date, trigger_time, read_status, project_id, task_id, created_at, updated_at)
                     VALUES (?, ?, ?, ?, ?, NOW(), ?, ?, ?, NOW(), NOW())`,
                    [
                        userId,
                        'Claim Update',
                        notificationBody,
                        action,
                        new Date().toISOString().slice(0, 10), // trigger_date (YYYY-MM-DD)
                        new Date().toISOString().slice(0, 19), // trigger_time (HH:MM:SS)
                        projectId || null,
                        claimId
                    ]
                );
            } catch (notificationError) {
                console.error('Claim notification error:', notificationError);
                // Continue with claim update even if notification fails
            }
            // Optionally: handle notification logic here if needed
        }
        return true;
    }
}