import { db } from "../utils/database.js";

async function findAllTasks(startDate = null, endDate = null) {
    try {
        let query = `
            SELECT 
                t.*, 
                u.emp_id, 
                u.name, 
                tt.activity_name AS tasktype_name,
                p.project_id AS project_code,
                p.project_name AS project_name,
                c.company_name AS customer_name,
                ct.contact_name AS contact_name
            FROM tasks t
            LEFT JOIN users u ON t.user_id = u.id
            LEFT JOIN tasktypes tt ON t.tasktype_id = tt.id
            LEFT JOIN projects p ON t.project_id = p.id
            LEFT JOIN companies c ON p.customer_id = c.id
            LEFT JOIN contacts ct ON p.contact_id = ct.id
            WHERE t.tasktype_id != 1
        `;
        let params = [];

        // Add date filtering if provided
        if (startDate && endDate) {
            query += " AND DATE(t.start_date) BETWEEN ? AND ?";
            params.push(startDate, endDate);
        } else if (startDate) {
            query += " AND DATE(t.start_date) >= ?";
            params.push(startDate);
        } else if (endDate) {
            query += " AND DATE(t.start_date) <= ?";
            params.push(endDate);
        }

        const [tasks] = await db.query(query, params);
        return tasks;
    } catch (error) {
        console.error("Error fetching tasks:", error);
        throw error;
    }
}

async function findTaskById(id) {
    try {
        const task = await db.query("SELECT * FROM tasks WHERE id = ?", [id]);
        return task[0]; // Return first result since we're looking for a single task
    } catch (error) {
        console.error("Error fetching task by id:", error);
        throw error;
    }
}

export {
    findAllTasks,
    findTaskById
}