import { db } from '../utils/database.js';

export class TaskType {
    static async create(taskTypeData) {
        const query = `
            INSERT INTO tasktypes (
                activity_id, activity_name, activity_icon,
                allow_checkin_checkout, allow_startdate_enddate,
                show_calendar, mark_completed, allow_claim,
                allow_edit, status, created_at, updated_at
            ) VALUES (
                ?, ?, ?, 
                ?, ?, 
                ?, ?, ?, 
                ?, 1, NOW(), NOW()
            )
        `;

        // Default to 0 if not provided
        const allow_checkin_checkout = typeof taskTypeData.allow_checkin_checkout !== 'undefined' ? Boolean(taskTypeData.allow_checkin_checkout) : 0;
        const allow_startdate_enddate = typeof taskTypeData.allow_startdate_enddate !== 'undefined' ? Boolean(taskTypeData.allow_startdate_enddate) : 0;
        const show_calendar = typeof taskTypeData.show_calendar !== 'undefined' ? Boolean(taskTypeData.show_calendar) : 0;
        const mark_completed = typeof taskTypeData.mark_completed !== 'undefined' ? Boolean(taskTypeData.mark_completed) : 0;
        const allow_claim = typeof taskTypeData.allow_claim !== 'undefined' ? Boolean(taskTypeData.allow_claim) : 0;
        const allow_edit = typeof taskTypeData.allow_edit !== 'undefined' ? Boolean(taskTypeData.allow_edit) : 0;

        const result = await db.query(query, [
            taskTypeData.activity_id,
            taskTypeData.activity_name,
            taskTypeData.activity_icon,
            allow_checkin_checkout,
            allow_startdate_enddate,
            show_calendar,
            mark_completed,
            allow_claim,
            allow_edit
        ]);
        
        return result.insertId;
    }

    static async update(id, taskTypeData) {
        const query = `
            UPDATE tasktypes 
            SET activity_id = ?,
                activity_name = ?,
                activity_icon = ?,
                allow_checkin_checkout = ?,
                allow_startdate_enddate = ?,
                show_calendar = ?,
                mark_completed = ?,
                allow_claim = ?,
                allow_edit = ?,
                updated_at = NOW()
            WHERE id = ? AND status = 1
        `;

        // Default to 0 if not provided
        const allow_checkin_checkout = typeof taskTypeData.allow_checkin_checkout !== 'undefined' ? Boolean(taskTypeData.allow_checkin_checkout) : 0;
        const allow_startdate_enddate = typeof taskTypeData.allow_startdate_enddate !== 'undefined' ? Boolean(taskTypeData.allow_startdate_enddate) : 0;
        const show_calendar = typeof taskTypeData.show_calendar !== 'undefined' ? Boolean(taskTypeData.show_calendar) : 0;
        const mark_completed = typeof taskTypeData.mark_completed !== 'undefined' ? Boolean(taskTypeData.mark_completed) : 0;
        const allow_claim = typeof taskTypeData.allow_claim !== 'undefined' ? Boolean(taskTypeData.allow_claim) : 0;
        const allow_edit = typeof taskTypeData.allow_edit !== 'undefined' ? Boolean(taskTypeData.allow_edit) : 0;

        return db.query(query, [
            taskTypeData.activity_id,
            taskTypeData.activity_name,
            taskTypeData.activity_icon,
            allow_checkin_checkout,
            allow_startdate_enddate,
            show_calendar,
            mark_completed,
            allow_claim,
            allow_edit,
            id
        ]);
    }

    static async softDelete(id) {
        const query = `
            UPDATE tasktypes 
            SET status = 0,
                updated_at = NOW() 
            WHERE id = ?
        `;
        return db.query(query, [id]);
    }

    static async findById(id) {
        const query = 'SELECT * FROM tasktypes WHERE id = ? AND status = 1';
        const [taskType] = await db.query(query, [id]);
        return taskType;
    }

    static async list() {
        const query = 'SELECT * FROM tasktypes WHERE status = 1 ORDER BY created_at DESC';
        return db.query(query);
    }

    static async listActiveExceptOne() {
        const query = 'SELECT * FROM tasktypes WHERE status = 1 AND id != 1';
        let rows = await db.query(query);
        return rows;
    }
}