import { Router } from 'express';
import { getAllActionReports, datatableActionReports } from '../controllers/actionReport.controller.js';
import { verifyToken } from '../middleware/auth.js';
import actionReportRoutes from './actionReport.routes.js';

const router = Router();

// Route to get all action reports
router.post('/all', verifyToken, getAllActionReports);
router.post('/datatable-action-reports', verifyToken, datatableActionReports);

export default router;