import { Router } from 'express';
import { body } from 'express-validator';
import { appLogin } from '../controllers/appauth.controller.js';

const router = Router();

const loginValidation = [
    body('mobile_no').notEmpty().withMessage('Mobile number is required'),
    body('password').notEmpty().withMessage('Password is required'),
    body('deviceId').notEmpty().withMessage('Device ID is required'),
    body('app_version').notEmpty().withMessage('App version is required'),
    body('device_token').notEmpty().withMessage('Device token is required')
];

router.post('/login', loginValidation, appLogin);

export default router;