import { Router } from 'express';
import { body } from 'express-validator';
import { getAttendanceConfig, updateAttendanceConfig } from '../controllers/attendanceconfig.controller.js';
import { verifyToken } from '../middleware/auth.js';

const router = Router();

const configValidation = [
    body('id').notEmpty().withMessage('Config ID is required'),
    body('allow_branch').isIn(['0', '1']).withMessage('Allow branch must be 0 or 1'),
    body('allow_sitevisit').isIn(['0', '1']).withMessage('Allow site visit must be 0 or 1'),
    body('allow_outside').isIn(['0', '1']).withMessage('Allow outside must be 0 or 1'),
    body('allow_outsideapproval').isIn(['0', '1']).withMessage('Allow outside approval must be 0 or 1'),
    body('allow_branchfirst_site').isIn(['0', '1']).withMessage('Allow branch first site must be 0 or 1'),
    body('allow_branchlast_site').isIn(['0', '1']).withMessage('Allow branch last site must be 0 or 1'),
    body('capture_time').notEmpty().withMessage('Capture time is required'),
    body('capture_km').notEmpty().withMessage('Capture KM is required'),
    body('transport_mode_edit_bike').isIn(['true', 'false']).withMessage('Transport mode edit bike must be true or false'),
    body('allow_other_task_outside').isIn(['0', '1']).withMessage('Allow other task outside must be 0 or 1')
];

router.get('/', verifyToken, getAttendanceConfig);
router.put('/', verifyToken, configValidation, updateAttendanceConfig);

export default router;