import { Router } from 'express';
import { body } from 'express-validator';
import { login } from '../controllers/auth.controller.js';

const router = Router();

router.post('/login', [
    body('mobile')
        .notEmpty()
        .withMessage('Mobile number is required')
        .matches(/^[0-9]{10}$/)
        .withMessage('Please enter a valid 10-digit mobile number'),
    body('password')
        .notEmpty()
        .withMessage('Password is required')
], login);

export default router;