import { Router } from 'express';
import { body } from 'express-validator';
import { createBranch, updateBranch, deleteBranch, listBranches } from '../controllers/branch.controller.js';
import { verifyToken } from '../middleware/auth.js';

const router = Router();

const branchValidation = [
    body('branch_name').notEmpty().withMessage('Branch name is required'),
    body('location').notEmpty().withMessage('Location is required'),
    body('branch_lat').isFloat().withMessage('Valid latitude is required'),
    body('branch_long').isFloat().withMessage('Valid longitude is required'),
    body('radius').isFloat().withMessage('Valid radius is required')
];

router.post('/', verifyToken, branchValidation, createBranch);
router.put('/:id', verifyToken, branchValidation, updateBranch);
router.delete('/:id', verifyToken, deleteBranch);
router.get('/', verifyToken, listBranches);

export default router;